/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.wro4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.Log;
import org.fao.geonet.wro4j.DiskbackedCache;
import org.fao.geonet.wro4j.GeonetWroModelFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.cache.impl.LruMemoryCacheStrategy;
import ro.isdc.wro.manager.factory.ConfigurableWroManagerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;

public class GeonetworkWrojManagerFactory
extends ConfigurableWroManagerFactory {
    public static final String WRO4J_LOG = "geonetwork.wro4j";
    private static final String CACHE_PROP_KEY = "cacheStrategy";
    private static final String SIZE_PROP_KEY = "lruSize";
    private CacheStrategy<CacheKey, CacheValue> cacheStrategy = null;
    private ServletContext servletContext;

    protected WroModelFactory newModelFactory() {
        return new GeonetWroModelFactory(){

            @Override
            protected Properties getConfigProperties() {
                return GeonetworkWrojManagerFactory.this.newConfigProperties();
            }
        };
    }

    protected CacheStrategy<CacheKey, CacheValue> newCacheStrategy() {
        Properties properties = this.newConfigProperties();
        int lruSize = Integer.parseInt(properties.getProperty(SIZE_PROP_KEY, "128"));
        switch (properties.getProperty(CACHE_PROP_KEY, "lru")) {
            case "disk-memory": {
                if (this.cacheStrategy != null) break;
                this.cacheStrategy = this.initDiskbackedCache(lruSize);
                break;
            }
            default: {
                this.cacheStrategy = new LruMemoryCacheStrategy(lruSize);
            }
        }
        return this.cacheStrategy;
    }

    public void destroy() {
        super.destroy();
        if (this.cacheStrategy != null) {
            this.cacheStrategy.destroy();
        }
    }

    private DiskbackedCache initDiskbackedCache(int lruSize) {
        block44: {
            Properties bundledProperties = this.readPropertiesFile("/git.properties");
            String bundledGitRevision = bundledProperties.getProperty("git.commit.id", "");
            Path dataDirPath = null;
            boolean gitVersionMatch = false;
            try {
                Throwable throwable;
                if (ApplicationContextHolder.get() != null) {
                    GeonetworkDataDirectory geonetworkDataDirectory = (GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class);
                    if (ApplicationContextHolder.get() instanceof XmlWebApplicationContext) {
                        this.servletContext = ((XmlWebApplicationContext)ApplicationContextHolder.get()).getServletContext();
                    }
                    dataDirPath = geonetworkDataDirectory.getSystemDataDir();
                }
                if (dataDirPath == null) break block44;
                Properties propInDataDir = new Properties();
                Path propFileInDataDir = dataDirPath.resolve("git.properties");
                if (Files.exists(propFileInDataDir, new LinkOption[0])) {
                    throwable = null;
                    try (InputStream propertiesInputStream = Files.newInputStream(propFileInDataDir, new OpenOption[0]);){
                        propInDataDir.load(propertiesInputStream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                throwable = null;
                try (OutputStream propertiesOutputStream = Files.newOutputStream(propFileInDataDir, new OpenOption[0]);){
                    bundledProperties.store(propertiesOutputStream, "Copied from GN git.properties on " + DateTimeFormatter.ISO_DATE_TIME.format(OffsetDateTime.now()));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                String dataDirGitVersion = propInDataDir.getProperty("git.commit.id");
                gitVersionMatch = bundledGitRevision.equals(dataDirGitVersion);
                if (this.servletContext == null) break block44;
                try (InputStream bundledPrebuiltCacheStream = this.servletContext.getResourceAsStream("/WEB-INF/prebuilt/wro4j-cache.mv.db");){
                    if (bundledPrebuiltCacheStream != null) {
                        Path dataWroCache = dataDirPath.resolve("wro4j-cache.mv.db");
                        if (!gitVersionMatch || Files.notExists(dataWroCache, new LinkOption[0])) {
                            Files.copy(bundledPrebuiltCacheStream, dataWroCache, StandardCopyOption.REPLACE_EXISTING);
                            Path customLessFiles = dataDirPath.resolve("node_less_files").resolve("gn_dynamic_style.json");
                            if (Files.exists(customLessFiles, new LinkOption[0])) {
                                this.removeCSSFromCache(dataDirPath);
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                Log.error((String)WRO4J_LOG, (String)"Error trying to initialize pre-populated wro4j-cache", (Throwable)e);
            }
        }
        return new DiskbackedCache(lruSize, null);
    }

    private void removeCSSFromCache(Path dataDirPath) {
        try (DiskbackedCache tempCache = new DiskbackedCache(50, dataDirPath.resolve("wro4j-cache").toString());){
            tempCache.deleteCSSItems();
        }
        catch (IOException e) {
            throw new WroRuntimeException("Error removing CSS files from the wro4j cache", (Throwable)e);
        }
    }

    private Properties readPropertiesFile(String propertiesFile) {
        Properties properties = new Properties();
        try (InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream(propertiesFile);){
            properties.load(input);
        }
        catch (IOException e) {
            Log.error((String)WRO4J_LOG, (String)("Cannot read " + propertiesFile + " file"), (Throwable)e);
        }
        return properties;
    }
}

