/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester;

import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.jdom.Element;

public class RecordInfo {
    private static final long SECONDS_PER_DAY = 86400L;
    public String id;
    public String uuid;
    public String changeDate;
    public String schema;
    public String source;
    public String isTemplate;
    private boolean dateWasNull;

    public RecordInfo(String uuid, String changeDate) {
        this(uuid, changeDate, null, null);
    }

    public RecordInfo(String uuid, String changeDate, String schema, String source) {
        if (changeDate == null) {
            this.dateWasNull = true;
            changeDate = new ISODate().toString();
        }
        this.uuid = uuid;
        this.changeDate = changeDate;
        this.schema = schema;
        this.source = source;
    }

    public RecordInfo(Element record) {
        this.id = record.getChildText("id");
        this.uuid = record.getChildText("uuid");
        this.isTemplate = record.getChildText("istemplate");
        this.changeDate = record.getChildText("changedate");
    }

    public RecordInfo(AbstractMetadata record) {
        this.id = "" + record.getId();
        this.uuid = record.getUuid();
        this.isTemplate = record.getDataInfo().getType().codeString;
        this.changeDate = record.getDataInfo().getChangeDate().getDateAndTime();
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean isMoreRecentThan(String localChangeDate) {
        if (this.dateWasNull) {
            return true;
        }
        ISODate remoteDate = new ISODate(this.changeDate);
        ISODate localDate = new ISODate(localChangeDate);
        if (remoteDate.timeDifferenceInSeconds(localDate) == 0L) {
            return false;
        }
        return remoteDate.timeDifferenceInSeconds(localDate) > -86400L;
    }

    public boolean isOlderThan(String remoteChangeDate) {
        if (this.dateWasNull) {
            return true;
        }
        ISODate remoteDate = new ISODate(remoteChangeDate);
        ISODate localDate = new ISODate(this.changeDate);
        return remoteDate.timeDifferenceInSeconds(localDate) > -86400L;
    }

    public boolean equals(Object o) {
        if (o instanceof RecordInfo) {
            RecordInfo ri = (RecordInfo)o;
            return this.uuid.equals(ri.uuid);
        }
        return false;
    }

    public String getUuid() {
        return this.uuid;
    }
}

