/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest;

import java.nio.file.Path;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.api.tools.i18n.TranslationPackBuilder;
import org.fao.geonet.domain.HarvestHistory;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.exceptions.JeevesException;
import org.fao.geonet.exceptions.MissingParameterEx;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.HarvestInfoProvider;
import org.fao.geonet.kernel.harvest.Common;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.kernel.harvest.harvester.AbstractParams;
import org.fao.geonet.kernel.harvest.harvester.HarversterJobListener;
import org.fao.geonet.kernel.setting.HarvesterSettingsManager;
import org.fao.geonet.repository.HarvestHistoryRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.jpa.domain.Specification;

public class HarvestManagerImpl
implements HarvestInfoProvider,
HarvestManager {
    private final List<String> summaryHarvesterSettings = Arrays.asList("harvesting", "node", "site", "name", "uuid", "url", "capabUrl", "baseUrl", "host", "useAccount", "ogctype", "options", "status", "info", "lastRun", "ownerGroup", "ownerUser");
    private HarvesterSettingsManager settingMan;
    private DataManager dataMan;
    private Path xslPath;
    private ServiceContext context;
    private boolean readOnly;
    private ConfigurableApplicationContext applicationContext;
    private Map<String, AbstractHarvester> hmHarvesters = new HashMap<String, AbstractHarvester>();
    private Map<String, AbstractHarvester> hmHarvestLookup = new HashMap<String, AbstractHarvester>();
    private TranslationPackBuilder translationPackBuilder;

    @Override
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void init(ServiceContext context, boolean isReadOnly) throws Exception {
        Element entries;
        this.context = context;
        this.dataMan = (DataManager)context.getBean(DataManager.class);
        this.settingMan = (HarvesterSettingsManager)context.getBean(HarvesterSettingsManager.class);
        this.translationPackBuilder = (TranslationPackBuilder)context.getBean(TranslationPackBuilder.class);
        this.applicationContext = context.getApplicationContext();
        this.readOnly = isReadOnly;
        Log.debug((String)"geonetwork.harvest-man", (Object)("HarvesterManager initializing, READONLYMODE is " + this.readOnly));
        this.xslPath = context.getAppPath().resolve("xsl").resolve("xml/harvesting/");
        AbstractHarvester.getScheduler().getListenerManager().addJobListener((JobListener)HarversterJobListener.getInstance(this));
        Element harvesting = this.settingMan.getList(null);
        if (harvesting != null && (entries = harvesting.getChild("children")) != null) {
            for (Object o : entries.getChildren()) {
                Element node = this.transform((Element)o);
                String type = node.getAttributeValue("type");
                String id = node.getAttributeValue("id");
                try {
                    AbstractHarvester<?, ?> ah = AbstractHarvester.create(type, context);
                    ah.init(node, context);
                    this.hmHarvesters.put(ah.getID(), ah);
                    this.hmHarvestLookup.put(((AbstractParams)ah.getParams()).getUuid(), ah);
                }
                catch (OperationAbortedEx oae) {
                    Log.error((String)"geonetwork.harvest-man", (Object)("Cannot create harvester " + id + " of type \"" + type + "\""), (Throwable)oae);
                }
            }
        }
    }

    private Element transformSort(Element nodes, String sortField) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sortField", sortField);
        return Xml.transform((Element)nodes, (Path)this.xslPath.resolve("sort-harvesters.xsl"), params);
    }

    private Element transform(Element node) throws Exception {
        String type = node.getChildText("value");
        node = (Element)node.clone();
        return Xml.transform((Element)node, (Path)this.xslPath.resolve(type + ".xsl"));
    }

    @Override
    public void shutdown() {
        for (AbstractHarvester ah : this.hmHarvesters.values()) {
            try {
                ah.shutdown();
            }
            catch (SchedulerException e) {
                Log.error((String)"geonetwork.harvest-man", (Object)("Error shutting down" + ah.getID()), (Throwable)e);
            }
        }
        try {
            AbstractHarvester.shutdownScheduler();
        }
        catch (SchedulerException e) {
            Log.error((String)"geonetwork.harvest-man", (Object)"Error shutting down harvester scheduler");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Element get(String id, ServiceContext context, String sort) throws Exception {
        Element result = null;
        result = id == null ? this.settingMan.getList(null) : (id.equals("-1") ? this.settingMan.getList(this.summaryHarvesterSettings) : this.settingMan.get("harvesting/id:" + id, -1));
        if (result == null) {
            return null;
        }
        Profile profile = context.getUserSession().getProfile();
        if (id != null && !id.equals("-1")) {
            if (profile == Profile.Administrator) {
                result = this.transform(result);
                this.addInfo(result);
                return result;
            } else {
                GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
                AccessManager am = (AccessManager)gc.getBean(AccessManager.class);
                Set groups = am.getVisibleGroups(context.getUserSession().getUserIdAsInt());
                Element nodeGroup = (result = this.transform(result)).getChild("ownerGroup");
                if (nodeGroup == null) return null;
                if (!groups.contains(Integer.valueOf(nodeGroup.getValue()))) return null;
                this.addInfo(result);
            }
            return result;
        }
        Element nodes = result.getChild("children");
        result = new Element("nodes");
        if (nodes == null) return result;
        if (profile == Profile.Administrator) {
            for (Object o : nodes.getChildren()) {
                Element node = this.transform((Element)o);
                this.addInfo(node);
                result.addContent((Content)node);
            }
        } else {
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            AccessManager am = (AccessManager)gc.getBean(AccessManager.class);
            Set groups = am.getVisibleGroups(context.getUserSession().getUserIdAsInt());
            for (Object o : nodes.getChildren()) {
                Element node = this.transform((Element)o);
                Element nodeGroup = node.getChild("ownerGroup");
                if (nodeGroup == null || StringUtils.isEmpty((String)nodeGroup.getValue()) || !StringUtils.isNumeric((String)nodeGroup.getValue()) || !groups.contains(Integer.valueOf(nodeGroup.getValue()))) continue;
                this.addInfo(node);
                result.addContent((Content)node);
            }
        }
        if (sort == null) return result;
        return this.transformSort(result, sort);
    }

    @Override
    public String addHarvesterReturnId(Element node, String ownerId) throws JeevesException, SQLException {
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("Adding harvesting node : \n" + Xml.getString((Element)node)));
        }
        String type = node.getAttributeValue("type");
        AbstractHarvester<?, ?> ah = AbstractHarvester.create(type, this.context);
        Element ownerIdE = new Element("ownerId");
        ownerIdE.setText(ownerId);
        node.addContent((Content)ownerIdE);
        ah.add(node);
        this.hmHarvesters.put(ah.getID(), ah);
        this.hmHarvestLookup.put(((AbstractParams)ah.getParams()).getUuid(), ah);
        this.translationPackBuilder.clearCache();
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("Added node with id : \n" + ah.getID()));
        }
        return ah.getID();
    }

    @Override
    public String addHarvesterReturnUUID(Element node) throws JeevesException, SQLException {
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("Adding harvesting node : \n" + Xml.getString((Element)node)));
        }
        String type = node.getAttributeValue("type");
        AbstractHarvester<?, ?> ah = AbstractHarvester.create(type, this.context);
        ah.add(node);
        this.hmHarvesters.put(ah.getID(), ah);
        this.hmHarvestLookup.put(((AbstractParams)ah.getParams()).getUuid(), ah);
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("HarvestManager added node with id: " + ah.getID() + " and uuid: " + ((AbstractParams)ah.getParams()).getUuid()));
        }
        this.translationPackBuilder.clearCache();
        return ((AbstractParams)ah.getParams()).getUuid();
    }

    @Override
    public synchronized String createClone(String id, String ownerId, ServiceContext context) throws Exception {
        Element name;
        Element site;
        Element node = this.get(id, context, null);
        if (node == null) {
            return null;
        }
        Element info = node.getChild("info");
        if (info != null) {
            info.removeContent();
        }
        if ((site = node.getChild("site")) != null && (name = site.getChild("name")) != null) {
            String nameStr = name.getText();
            name.setText("clone: " + nameStr);
        }
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("Cloning harvesting node : \n" + Xml.getString((Element)node)));
        }
        Element ownerIdE = new Element("ownerId");
        ownerIdE.setText(ownerId);
        node.addContent((Content)ownerIdE);
        return this.addHarvesterReturnId(node, ownerId);
    }

    @Override
    public synchronized boolean update(Element node, String ownerId) throws BadInputEx, SQLException, SchedulerException {
        String id;
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("Updating harvesting node : \n" + Xml.getString((Element)node)));
        }
        if ((id = node.getAttributeValue("id")) == null) {
            throw new MissingParameterEx("attribute:id", (Object)node);
        }
        AbstractHarvester ah = this.hmHarvesters.get(id);
        if (ah == null) {
            return false;
        }
        Element ownerIdE = new Element("ownerId");
        ownerIdE.setText(ownerId);
        node.addContent((Content)ownerIdE);
        ah.update(node);
        Element site = node.getChild("site");
        if (site != null && site.getChild("translations") != null) {
            this.translationPackBuilder.clearCache();
        }
        return true;
    }

    @Override
    public synchronized Common.OperResult remove(String id) throws Exception {
        try {
            if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
                Log.debug((String)"geonetwork.harvest-man", (Object)("Removing harvesting with id : " + id));
            }
            if (!NumberUtils.isDigits((String)id)) {
                return Common.OperResult.NOT_FOUND;
            }
            AbstractHarvester ah = this.hmHarvesters.get(id);
            String harvesterSetting = this.settingMan.getValue("harvesting/id:" + id);
            String uuid = this.settingMan.getValue("harvesting/id:" + id + "/site/uuid");
            if (StringUtils.isNotBlank((String)harvesterSetting)) {
                this.settingMan.remove("harvesting/id:" + id);
                HarvestHistoryRepository historyRepository = (HarvestHistoryRepository)this.context.getBean(HarvestHistoryRepository.class);
                historyRepository.markAllAsDeleted(uuid);
                this.hmHarvesters.remove(id);
                if (ah != null) {
                    ah.destroy();
                }
                this.translationPackBuilder.clearCache();
                return Common.OperResult.OK;
            }
            return Common.OperResult.NOT_FOUND;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Common.OperResult start(String id) throws SQLException, SchedulerException {
        AbstractHarvester ah;
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("Starting harvesting with id : " + id));
        }
        if ((ah = this.hmHarvesters.get(id)) == null) {
            return Common.OperResult.NOT_FOUND;
        }
        return ah.start();
    }

    @Override
    public Common.OperResult stop(String id, Common.Status status) throws SQLException, SchedulerException {
        AbstractHarvester ah;
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("Stopping harvesting with id : " + id));
        }
        if ((ah = this.hmHarvesters.get(id)) == null) {
            return Common.OperResult.NOT_FOUND;
        }
        return ah.stop(status);
    }

    @Override
    public Common.OperResult run(String id) throws SQLException, SchedulerException {
        if (!this.readOnly) {
            AbstractHarvester ah;
            if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
                Log.debug((String)"geonetwork.harvest-man", (Object)("Running harvesting with id: " + id));
            }
            if ((ah = this.hmHarvesters.get(id)) == null) {
                return Common.OperResult.NOT_FOUND;
            }
            return ah.run();
        }
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("GeoNetwork is running in read-only mode: skipping run of harvester with id: " + id));
        }
        return null;
    }

    @Override
    public Common.OperResult invoke(String id) {
        if (!this.readOnly) {
            AbstractHarvester ah;
            if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
                Log.debug((String)"geonetwork.harvest-man", (Object)("Invoking harvester with id: " + id));
            }
            if ((ah = this.hmHarvesters.get(id)) == null) {
                return Common.OperResult.NOT_FOUND;
            }
            return ah.invoke();
        }
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("GeoNetwork is running in read-only mode: skipping invocation of harvester with id: " + id));
        }
        return null;
    }

    public Element getHarvestInfo(String harvestUuid, String id, String uuid) {
        Element info = new Element("harvestInfo");
        AbstractHarvester ah = this.hmHarvestLookup.get(harvestUuid);
        if (ah != null) {
            ah.addHarvestInfo(info, id, uuid);
        }
        return info;
    }

    @Override
    public AbstractHarvester getHarvester(String harvestUuid) {
        return this.hmHarvestLookup.get(harvestUuid);
    }

    private void addInfo(Element node) {
        String id = node.getAttributeValue("id");
        if (this.hmHarvesters.get(id) != null) {
            this.hmHarvesters.get(id).addInfo(node);
        } else {
            Log.warning((String)"geonetwork.harvest-man", (Object)("Trying to add info to a non existing harvester with id : " + id));
        }
    }

    public void removeInfo(String id, String ownerId) throws Exception {
        Element node = this.get(id, this.context, null);
        if (node != null) {
            Element info = node.getChild("info");
            if (info != null) {
                info.removeContent();
            }
            this.update(node, ownerId);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public synchronized Common.OperResult clearBatch(String id) throws Exception {
        AbstractHarvester ah;
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("Clearing harvesting with id : " + id));
        }
        if ((ah = this.hmHarvesters.get(id)) == null) {
            return Common.OperResult.NOT_FOUND;
        }
        long elapsedTime = System.currentTimeMillis();
        String harvesterUUID = ((AbstractParams)ah.getParams()).getUuid();
        Specification specification = MetadataSpecs.hasHarvesterUuid((String)harvesterUUID);
        int numberOfRecordsRemoved = this.dataMan.batchDeleteMetadataAndUpdateIndex(specification);
        ah.emptyResult();
        elapsedTime = (System.currentTimeMillis() - elapsedTime) / 1000L;
        this.removeInfo(id, this.context.getUserSession().getUserId());
        ah.emptyResult();
        Element historyEl = new Element("result");
        historyEl.addContent((Content)new Element("cleared").setAttribute("recordsRemoved", numberOfRecordsRemoved + ""));
        String lastRun = OffsetDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_DATE_TIME);
        ISODate lastRunDate = new ISODate(lastRun);
        HarvestHistoryRepository historyRepository = (HarvestHistoryRepository)this.context.getBean(HarvestHistoryRepository.class);
        HarvestHistory history = new HarvestHistory();
        history.setDeleted(true);
        history.setElapsedTime((int)elapsedTime);
        history.setHarvestDate(lastRunDate);
        history.setHarvesterName(((AbstractParams)ah.getParams()).getName());
        history.setHarvesterType(ah.getType());
        history.setHarvesterUuid(((AbstractParams)ah.getParams()).getUuid());
        history.setInfo(historyEl);
        history.setParams(((AbstractParams)ah.getParams()).getNodeElement());
        historyRepository.save((Object)history);
        return Common.OperResult.OK;
    }

    @Override
    public void rescheduleActiveHarvesters() {
        String defaultTimeZoneId = TimeZone.getDefault().getID();
        for (Map.Entry<String, AbstractHarvester> pair : this.hmHarvesters.entrySet()) {
            AbstractHarvester harvester = pair.getValue();
            if (!Common.Status.ACTIVE.equals((Object)harvester.getStatus())) continue;
            try {
                TimeZone triggerTimeZone = harvester.getTriggerTimezone();
                String triggerTimeZoneId = defaultTimeZoneId;
                if (triggerTimeZone != null) {
                    triggerTimeZoneId = triggerTimeZone.getID();
                }
                if (StringUtils.equals((String)defaultTimeZoneId, (String)triggerTimeZoneId)) continue;
                harvester.doReschedule();
            }
            catch (SchedulerException e) {
                Log.error((String)"geonetwork.harvest-man", (Object)String.format("Error rescheduling harvester %s - '%s'", harvester.getID(), ((AbstractParams)harvester.getParams()).getName()), (Throwable)e);
            }
        }
    }
}

