/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.component.harvester.csw;

import com.google.common.base.Function;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.fao.geonet.Constants;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.csw.common.exceptions.MissingParameterValueEx;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.kernel.csw.CatalogService;
import org.fao.geonet.kernel.csw.CswHarvesterResponseExecutionService;
import org.fao.geonet.kernel.csw.services.AbstractOperation;
import org.fao.geonet.kernel.csw.services.SupportedResourceType;
import org.fao.geonet.kernel.harvest.Common;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.services.harvesting.Util;
import org.fao.geonet.util.ISOPeriod;
import org.fao.geonet.util.MailSender;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

public class Harvest
extends AbstractOperation
implements CatalogService {
    static final String NAME = "Harvest";
    private ApplicationContext applicationContext;
    private String operationId = "Harvest";
    private Protocol protocol;

    public String getName() {
        return NAME;
    }

    public Element execute(Element request, ServiceContext serviceContext) throws CatalogException {
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("CSW Harvest execute, request is:\n" + Xml.getString((Element)request)));
        }
        try {
            Element response;
            this.applicationContext = serviceContext.getApplicationContext();
            this.checkService(request);
            this.checkVersion(request);
            String resourceType = this.checkResourceType(request);
            this.checkResourceFormat(request);
            String source = this.checkSource(request);
            this.operationId = "CSW.HarvestOperation:" + UUID.randomUUID().toString();
            Element node = this.createHarvestNode(request, resourceType, source, serviceContext);
            String responseHandler = request.getChildText("ResponseHandler", Csw.NAMESPACE_CSW);
            if (StringUtils.isEmpty((String)responseHandler)) {
                if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                    Log.debug((String)"geonetwork.csw.harvest", (Object)"CSW Harvest executes synchronously");
                }
                response = this.doHarvest(node, serviceContext, Mode.SYNCHRONOUS);
            } else {
                if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                    Log.debug((String)"geonetwork.csw.harvest", (Object)"CSW Harvest executes asynchronously");
                }
                this.checkResponseHandler(responseHandler);
                response = this.createAcknowledgeResponse(request);
                this.doHarvest(node, serviceContext, Mode.ASYNCHRONOUS);
                this.asynchronousHarvestResponse(node, responseHandler, serviceContext);
            }
            if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                Log.debug((String)"geonetwork.csw.harvest", (Object)("CSW Harvest execute returns:\n" + Xml.getString((Element)response)));
            }
            return response;
        }
        catch (CatalogException x) {
            Log.error((String)"geonetwork.csw.harvest", (Object)x.getMessage(), (Throwable)x);
            throw x;
        }
        catch (Exception x) {
            Log.error((String)"geonetwork.csw.harvest", (Object)x.getMessage(), (Throwable)x);
            throw new NoApplicableCodeEx("ERROR: " + x.getMessage());
        }
    }

    private void checkResponseHandler(String responseHandler) throws InvalidParameterValueEx {
        this.protocol = Protocol.validate(responseHandler);
        if (this.protocol == null) {
            throw new InvalidParameterValueEx("ResponseHandler", "Unsupported protocol in responseHandler " + responseHandler + ". Supported protocols are: ftp://, http://, and mailto:");
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)"CSW Harvest checkResponseHandler: OK");
        }
    }

    private void asynchronousHarvestResponse(Element harvester, String responseHandler, ServiceContext serviceContext) {
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("Asynchronous harvest run requested for " + responseHandler + ", starting in 1 minute"));
        }
        long delay = 1L;
        CswHarvesterResponseExecutionService.getExecutionService().schedule(new AsyncHarvestResponse(harvester, responseHandler, serviceContext), delay, TimeUnit.MINUTES);
    }

    private String checkResourceType(Element request) throws MissingParameterValueEx, InvalidParameterValueEx {
        String resourceType = request.getChildText("ResourceType", Csw.NAMESPACE_CSW);
        if (resourceType == null) {
            throw new MissingParameterValueEx("ResourceType");
        }
        SupportedResourceType supportedResourceType = SupportedResourceType.fromString((String)resourceType);
        if (supportedResourceType == null) {
            throw new InvalidParameterValueEx("ResourceType", "ResourceType not supported: " + resourceType);
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("CSW Harvest checkResourceType OK, returns: " + resourceType));
        }
        return resourceType;
    }

    private void checkResourceFormat(Element request) throws InvalidParameterValueEx {
        String resourceFormat = request.getChildText("ResourceFormat", Csw.NAMESPACE_CSW);
        if (StringUtils.isNotEmpty((String)resourceFormat) && !resourceFormat.equals("application/xml")) {
            throw new InvalidParameterValueEx("ResourceFormat", "ResourceFormat not supported: " + resourceFormat + ". This catalog only supports XML metadata.");
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)"CSW Harvest checkResourceFormat: OK");
        }
    }

    private String checkSource(Element request) throws MissingParameterValueEx, InvalidParameterValueEx {
        String source = request.getChildText("Source", Csw.NAMESPACE_CSW);
        if (source == null) {
            throw new MissingParameterValueEx("Source");
        }
        try {
            new URL(source);
        }
        catch (MalformedURLException x) {
            throw new InvalidParameterValueEx("Source", "Invalid source URL:" + source + " - " + x.getMessage());
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("CSW Harvest checkSource OK, returns: " + source));
        }
        return source;
    }

    public Element adaptGetRequest(Map<String, String> params) {
        String service = params.get("service");
        String version = params.get("version");
        String source = params.get("Source");
        String resourceType = params.get("ResourceType");
        String resourceFormat = params.get("ResourceFormat");
        String responseHandler = params.get("ResponseHandler");
        String harvestInterval = params.get("HarvestInterval");
        Element request = new Element(this.getName(), Csw.NAMESPACE_CSW);
        this.setAttrib(request, "service", service);
        this.setAttrib(request, "version", version);
        this.setAttrib(request, "Source", source);
        this.setAttrib(request, "ResourceType", resourceType);
        this.setAttrib(request, "ResourceFormat", resourceFormat);
        this.setAttrib(request, "ResponseHandler", responseHandler);
        this.setAttrib(request, "HarvestInterval", harvestInterval);
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("CSW Harvest adaptGetRequest returns:\n" + Xml.getString((Element)request)));
        }
        return request;
    }

    public Element retrieveValues(String parameterName) throws CatalogException {
        return null;
    }

    private Element createHarvestNode(Element request, String resourceType, String source, ServiceContext context) throws Exception {
        Element node = new Element("node");
        node = node.setAttribute("type", "csw");
        Element site = new Element("site");
        Element name = new Element("name").addContent(this.operationId);
        site.addContent((Content)name);
        Element capabilitiesUrl = new Element("capabilitiesUrl");
        capabilitiesUrl.addContent(source);
        site.addContent((Content)capabilitiesUrl);
        Element eleIcon = new Element("icon").addContent("csw.gif");
        site.addContent((Content)eleIcon);
        Element account = new Element("account");
        Element username = new Element("username");
        Element password = new Element("password");
        Element use = new Element("use").addContent("false");
        account.addContent((Content)use);
        account.addContent((Content)username);
        account.addContent((Content)password);
        site.addContent((Content)account);
        node.addContent((Content)site);
        Element options = new Element("options");
        Element eleEvery = new Element("every");
        Element eleOneRun = new Element("oneRunOnly");
        String harvestInterval = request.getChildText("HarvestInterval", Csw.NAMESPACE_CSW);
        if (StringUtils.isEmpty((String)harvestInterval) || harvestInterval.equals("P0Y0M0DT0H0M0S")) {
            eleEvery.addContent("90");
            eleOneRun.addContent("true");
        } else {
            int intervalInMinutes = ISOPeriod.iso8601Period2Minutes((String)harvestInterval);
            eleEvery.addContent(Integer.toString(intervalInMinutes));
            eleOneRun.addContent("false");
        }
        options.addContent((Content)eleEvery);
        options.addContent((Content)eleOneRun);
        node.addContent((Content)options);
        Element searches = new Element("searches");
        node.addContent((Content)searches);
        GeonetContext geonetContext = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = (SettingManager)geonetContext.getBean(SettingManager.class);
        boolean metadataPublic = sm.getValueAsBool("system/csw/metadataPublic", false);
        if (metadataPublic) {
            Element privileges = new Element("privileges");
            Element group = new Element("group");
            group.setAttribute("id", "1");
            Element operation1 = new Element("operation");
            operation1.setAttribute("name", "view");
            group.addContent((Content)operation1);
            Element operation2 = new Element("operation");
            operation2.setAttribute("name", "dynamic");
            group.addContent((Content)operation2);
            Element operation3 = new Element("operation");
            operation3.setAttribute("name", "featured");
            group.addContent((Content)operation3);
            privileges.addContent((Content)group);
            node.addContent((Content)privileges);
        }
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        HarvestManager hm = (HarvestManager)gc.getBean(HarvestManager.class);
        String uuid = hm.addHarvesterReturnUUID(node);
        node.setAttribute("uuid", uuid);
        node.addContent((Content)new Element("info"));
        AbstractHarvester harvester = hm.getHarvester(uuid);
        String id = harvester.getID();
        node.setAttribute("id", id);
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("** CSW Harvest createHarvestNode returns:\n" + Xml.getString((Element)node)));
        }
        return node;
    }

    private Element createHarvestResponse(Element harvester, ServiceContext context) throws Exception {
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("createHarvestResponse for harvester:\n" + Xml.getString((Element)harvester)));
        }
        Element harvestResponse = new Element("HarvestResponse", Csw.NAMESPACE_CSW);
        Element error = harvester.getChild("error");
        if (error == null) {
            Element transactionResponse = new Element("TransactionResponse", Csw.NAMESPACE_CSW);
            Element transactionSummary = new Element("TransactionSummary", Csw.NAMESPACE_CSW);
            Element info = harvester.getChild("info");
            Element result = info.getChild("result");
            Element totalInserted = new Element("totalInserted", Csw.NAMESPACE_CSW).setText(result.getChildText("added"));
            Element totalUpdated = new Element("totalUpdated", Csw.NAMESPACE_CSW).setText(result.getChildText("updated"));
            Element totalDeleted = new Element("totalDeleted", Csw.NAMESPACE_CSW).setText(result.getChildText("removed"));
            transactionSummary.addContent((Content)totalInserted);
            transactionSummary.addContent((Content)totalUpdated);
            transactionSummary.addContent((Content)totalDeleted);
            transactionResponse.addContent((Content)transactionSummary);
            harvestResponse.addContent((Content)transactionResponse);
        } else {
            harvestResponse.addContent((Content)this.createExceptionReport(error));
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("createHarvestResponse returns:\n" + Xml.getString((Element)harvestResponse)));
        }
        return harvestResponse;
    }

    private Element createExceptionReport(Element error) {
        Element exceptionReport = new Element("ExceptionReport", Csw.NAMESPACE_OWS);
        exceptionReport.setAttribute("version", "2.0.2");
        Element exception = new Element("Exception", Csw.NAMESPACE_OWS);
        Element exceptionText = new Element("ExceptionText", Csw.NAMESPACE_OWS);
        String exceptionClass = error.getChildText("class");
        String exceptionMessage = error.getChildText("message");
        exceptionText.setText(exceptionClass + ": " + exceptionMessage);
        exception.addContent((Content)exceptionText);
        exception.setAttribute("exceptionCode", "TransactionFailure");
        exceptionReport.addContent((Content)exception);
        return exceptionReport;
    }

    private Element createAcknowledgeResponse(Element asyncRequest) {
        Element response = new Element(this.getName() + "Response", Csw.NAMESPACE_CSW);
        Element acknowledgement = new Element("Acknowledgement", Csw.NAMESPACE_CSW);
        String timeStamp = new ISODate().toString();
        acknowledgement.setAttribute("timeStamp", timeStamp);
        Element echoedRequest = new Element("EchoedRequest", Csw.NAMESPACE_CSW);
        echoedRequest.addContent((Content)asyncRequest);
        acknowledgement.addContent((Content)echoedRequest);
        Element requestId = new Element("RequestId", Csw.NAMESPACE_CSW);
        requestId.addContent("urn:uuid:" + UUID.randomUUID().toString());
        acknowledgement.addContent((Content)requestId);
        response.addContent((Content)acknowledgement);
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("CSW Harvest createAcknowledgeResponse returns:\n" + Xml.getString((Element)response)));
        }
        return response;
    }

    private Element doHarvest(Element harvester, ServiceContext context, Mode mode) throws Exception {
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("doHarvest start in mode " + mode.toString()));
        }
        String id = harvester.getAttributeValue("id");
        Element activeParams = new Element("request");
        Element idele = new Element("id");
        idele.addContent(id);
        activeParams.addContent((Content)idele);
        Element response = Util.exec(activeParams, context, new Util.Job(){

            @Override
            public Common.OperResult execute(HarvestManager hm, String id) throws Exception {
                if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                    Log.debug((String)"geonetwork.csw.harvest", (Object)"doHarvest starting harvester job");
                }
                hm.start(id);
                return hm.run(id);
            }
        });
        if (mode == Mode.SYNCHRONOUS) {
            if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                Log.debug((String)"geonetwork.csw.harvest", (Object)"doHarvest waiting for harvester to finish");
            }
            this.waitForHarvesterToFinish(harvester, context);
            if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                Log.debug((String)"geonetwork.csw.harvest", (Object)"doHarvest finished waiting for harvester to finish");
            }
            response = this.createHarvestResponse(harvester, context);
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("doHarvest returns\n" + Xml.getString((Element)response)));
        }
        return response;
    }

    private boolean isRunning(Element harvester, ServiceContext context) throws Exception {
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("isRunning harvester:\n" + Xml.getString((Element)harvester)));
        }
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        String uuid = harvester.getAttribute("uuid").getValue();
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("uuid: " + uuid));
        }
        AbstractHarvester abstractHarvester = ((HarvestManager)gc.getBean(HarvestManager.class)).getHarvester(uuid);
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("abstractHarvester: " + abstractHarvester));
        }
        if (abstractHarvester == null) {
            return false;
        }
        abstractHarvester.addInfo(harvester);
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)("abstractHarvester added info: " + Xml.getString((Element)harvester)));
        }
        List runningElements = harvester.getChild("info").getChildren("running");
        for (Element runningElement : runningElements) {
            if (!runningElement.getText().equals("false")) continue;
            if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                Log.debug((String)"geonetwork.csw.harvest", (Object)"isRunning returns: false");
            }
            return false;
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)"isRunning returns: true");
        }
        return true;
    }

    private void waitForHarvesterToFinish(Element harvester, ServiceContext context) throws Exception {
        Thread.sleep(30000L);
        while (this.isRunning(harvester, context)) {
            if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                Log.debug((String)"geonetwork.csw.harvest", (Object)"CSW Harvest waitForHarvesterToFinish: harvester still running");
            }
            Thread.sleep(30000L);
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
            Log.debug((String)"geonetwork.csw.harvest", (Object)"CSW Harvest waitForHarvesterToFinish: harvester no longer running");
        }
    }

    private class AsyncHarvestResponse
    implements RunnableFuture<Object> {
        Semaphore ready = new Semaphore(0);
        private Element harvester;
        private String responseHandler;
        private ServiceContext serviceContext;

        AsyncHarvestResponse(Element harvester, String responseHandler, ServiceContext serviceContext) {
            try {
                Harvest.this.checkResponseHandler(responseHandler);
            }
            catch (InvalidParameterValueEx x) {
                throw new ExceptionInInitializerError("WARNING: unsupported protocol in responseHandler " + responseHandler + ", failed to create AsyncHarvestResponse");
            }
            this.harvester = harvester;
            this.responseHandler = responseHandler;
            this.serviceContext = serviceContext;
        }

        private void sendByEmail(String harvestResponse) {
            GeonetContext geonetContext = (GeonetContext)this.serviceContext.getHandlerContext("contextName");
            SettingManager settingManager = (SettingManager)geonetContext.getBean(SettingManager.class);
            String host = settingManager.getValue("system/feedback/mailServer/host");
            String port = settingManager.getValue("system/feedback/mailServer/port");
            String to = this.responseHandler.substring(Protocol.EMAIL.toString().length());
            MailSender sender = new MailSender(this.serviceContext);
            sender.send(host, Integer.parseInt(port), settingManager.getValue("system/feedback/mailServer/username"), settingManager.getValue("system/feedback/mailServer/password"), settingManager.getValueAsBool("system/feedback/mailServer/ssl"), settingManager.getValueAsBool("system/feedback/mailServer/tls"), settingManager.getValueAsBool("system/feedback/mailServer/ignoreSslCertificateErrors"), settingManager.getValue("system/feedback/email"), "GeoNetwork CSW Server", to, null, "Asynchronous CSW Harvest results delivery", harvestResponse);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendByFTP(String harvestResponse) {
            FTPClient ftpClient = null;
            try {
                int reply;
                ftpClient = new FTPClient();
                URI ftpUri = new URI(this.responseHandler);
                String host = ftpUri.getHost();
                int port = ftpUri.getPort();
                String path = ftpUri.getPath();
                String userInfo = ftpUri.getUserInfo();
                String user = null;
                String password = null;
                if (StringUtils.isNotEmpty((String)userInfo)) {
                    user = userInfo.substring(0, userInfo.indexOf(58));
                    password = userInfo.substring(userInfo.indexOf(58) + 1);
                }
                if (port > 0) {
                    ftpClient.connect(host, port);
                } else {
                    ftpClient.connect(host);
                }
                if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                    Log.debug((String)"geonetwork.csw.harvest", (Object)("Connected to " + host + "."));
                }
                if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                    Log.debug((String)"geonetwork.csw.harvest", (Object)ftpClient.getReplyString());
                }
                if (!FTPReply.isPositiveCompletion((int)(reply = ftpClient.getReplyCode()))) {
                    ftpClient.disconnect();
                    Log.warning((String)"geonetwork.csw.harvest", (Object)("Warning: FTP server refused connection. Not sending asynchronous CSW Harvest results to " + this.responseHandler));
                    return;
                }
                ftpClient.setControlKeepAliveTimeout(300L);
                if (user != null && password != null) {
                    ftpClient.login(user, password);
                } else {
                    ftpClient.login("anonymous", "");
                }
                if (StringUtils.isNotEmpty((String)path)) {
                    ftpClient.changeWorkingDirectory(path);
                }
                String filename = "CSW.Harvest.result";
                ByteArrayInputStream is = new ByteArrayInputStream(harvestResponse.getBytes(Constants.ENCODING));
                ftpClient.storeFile(filename, (InputStream)is);
                ((InputStream)is).close();
                ftpClient.logout();
            }
            catch (IOException x) {
                Log.error((String)"geonetwork.csw.harvest", (Object)("WARNING: " + x.getMessage() + " (this exception is swallowed)"), (Throwable)x);
            }
            catch (URISyntaxException x) {
                Log.error((String)"geonetwork.csw.harvest", (Object)("WARNING: " + x.getMessage() + " (this exception is swallowed)"), (Throwable)x);
            }
            finally {
                if (ftpClient != null && ftpClient.isConnected()) {
                    try {
                        ftpClient.disconnect();
                    }
                    catch (IOException x) {
                        Log.error((String)"geonetwork.csw.harvest", (Object)("WARNING: " + x.getMessage() + " (this exception is swallowed)"), (Throwable)x);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendByHTTP(String harvestResponse) {
            HttpPost method = new HttpPost(this.responseHandler);
            try {
                RequestConfig.Builder config = RequestConfig.custom();
                method.setEntity((HttpEntity)new StringEntity(harvestResponse));
                config.setAuthenticationEnabled(false);
                method.setConfig(config.build());
                final String requestHost = method.getURI().getHost();
                ClientHttpResponse httpResponse = ((GeonetHttpRequestFactory)Harvest.this.applicationContext.getBean(GeonetHttpRequestFactory.class)).execute((HttpUriRequest)method, (Function)new Function<HttpClientBuilder, Void>(){

                    @Nullable
                    public Void apply(@Nonnull HttpClientBuilder input) {
                        SettingManager settingManager = (SettingManager)Harvest.this.applicationContext.getBean(SettingManager.class);
                        Lib.net.setupProxy(settingManager, input, requestHost);
                        input.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler());
                        return null;
                    }
                });
                if (httpResponse.getStatusCode() != HttpStatus.OK) {
                    Log.warning((String)"geonetwork.csw.harvest", (Object)("WARNING: Failed to send HarvestResponse to responseHandler " + this.responseHandler + ", HTTP status is " + httpResponse.getStatusText()));
                }
            }
            catch (IOException x) {
                Log.warning((String)"geonetwork.csw.harvest", (Object)("WARNING: " + x.getMessage() + " (this exception is swallowed)"), (Throwable)x);
            }
            finally {
                method.releaseConnection();
            }
        }

        private void send(Element harvestResponse) {
            if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                Log.debug((String)"geonetwork.csw.harvest", (Object)"AsyncHarvestResponse send started");
            }
            String harvestResponseString = Xml.getString((Element)harvestResponse);
            if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                Log.debug((String)"geonetwork.csw.harvest", (Object)("Sending HarvestResponse to " + this.responseHandler));
            }
            switch (Harvest.this.protocol) {
                case EMAIL: {
                    this.sendByEmail(harvestResponseString);
                    break;
                }
                case FTP: {
                    this.sendByFTP(harvestResponseString);
                    break;
                }
                case HTTP: {
                    this.sendByHTTP(harvestResponseString);
                    break;
                }
                default: {
                    Log.warning((String)"geonetwork.csw.harvest", (Object)("WARNING: unsupported protocol for responseHandler " + this.responseHandler + ". HarvestResponse is not sent."));
                }
            }
            if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                Log.debug((String)"geonetwork.csw.harvest", (Object)"AsyncHarvestResponse send finished");
            }
        }

        @Override
        public void run() {
            try {
                if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                    Log.debug((String)"geonetwork.csw.harvest", (Object)"AsyncHarvestResponse run started");
                }
                Harvest.this.waitForHarvesterToFinish(this.harvester, this.serviceContext);
                Element harvestResponse = Harvest.this.createHarvestResponse(this.harvester, this.serviceContext);
                this.send(harvestResponse);
                this.ready.release();
                if (Log.isDebugEnabled((String)"geonetwork.csw.harvest")) {
                    Log.debug((String)"geonetwork.csw.harvest", (Object)"AsyncHarvestResponse run finished");
                }
            }
            catch (Exception x) {
                Log.error((String)"geonetwork.csw.harvest", (Object)("ERROR: AsyncHarvestResponse " + x.getMessage() + " (this exception is swallowed)"), (Throwable)x);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }

    private static enum Protocol {
        FTP{

            public String toString() {
                return "ftp://";
            }
        }
        ,
        HTTP{

            public String toString() {
                return "http://";
            }
        }
        ,
        EMAIL{

            public String toString() {
                return "mailto:";
            }
        };


        public static Protocol validate(String string) {
            if (StringUtils.isNotEmpty((String)string)) {
                for (Protocol protocol : Protocol.values()) {
                    if (!string.startsWith(protocol.toString())) continue;
                    return protocol;
                }
            }
            return null;
        }
    }

    private static enum Mode {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }
}

