/*
 * Decompiled with CFR 0.152.
 */
package v400;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.DatabaseMigrationTask;
import org.fao.geonet.utils.Log;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class UpdateAllSequenceValueToMax
extends DatabaseMigrationTask {
    public void update(Connection connection) throws SQLException {
        Log.debug((String)"geonetwork.database", (Object)"UpdateAllSequenceValueToMax");
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(true);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SequenceGenerator.class));
        for (BeanDefinition bd : scanner.findCandidateComponents("org.fao.geonet.domain")) {
            Class<?> cl;
            try {
                cl = Class.forName(bd.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            UpdateAllSequenceValueToMax.processClass(connection, cl);
        }
        UpdateAllSequenceValueToMax.updateTableSequence(connection, "Metadata", "id", "metadata_id_seq");
        UpdateAllSequenceValueToMax.updateTableSequence(connection, "MetadataDraft", "id", "metadata_id_seq");
    }

    public static void processClass(Connection connection, Class<?> cl) throws SQLException {
        String tablename;
        String sequenceName = cl.getAnnotation(SequenceGenerator.class).sequenceName();
        String name = cl.getAnnotation(SequenceGenerator.class).name();
        if (StringUtils.isEmpty((String)sequenceName) && StringUtils.isEmpty((String)name)) {
            Log.debug((String)"geonetwork.database", (Object)("  Sequence named " + cl.getAnnotation(SequenceGenerator.class).name() + " does not have a sequenceName or name field. Skipping sequence"));
            return;
        }
        if (StringUtils.isEmpty((String)sequenceName)) {
            sequenceName = name;
        }
        if (cl.isAnnotationPresent(Table.class)) {
            tablename = cl.getAnnotation(Table.class).name();
            if (StringUtils.isEmpty((String)tablename)) {
                tablename = cl.getSimpleName();
            }
        } else {
            tablename = cl.getSimpleName();
        }
        String keyColumnName = null;
        for (Field field : cl.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            if (field.isAnnotationPresent(Column.class)) {
                keyColumnName = field.getAnnotation(Column.class).name();
            }
            if (keyColumnName != null && !keyColumnName.isEmpty()) continue;
            keyColumnName = field.getName();
        }
        if (keyColumnName == null || keyColumnName.isEmpty()) {
            for (AccessibleObject accessibleObject : cl.getDeclaredMethods()) {
                if (!accessibleObject.isAnnotationPresent(Id.class)) continue;
                if (accessibleObject.isAnnotationPresent(Column.class)) {
                    keyColumnName = ((Method)accessibleObject).getAnnotation(Column.class).name();
                }
                if (keyColumnName != null && !keyColumnName.isEmpty()) continue;
                keyColumnName = UpdateAllSequenceValueToMax.getFieldName((Method)accessibleObject);
            }
        }
        if (keyColumnName == null || keyColumnName.isEmpty()) {
            keyColumnName = "id";
        }
        UpdateAllSequenceValueToMax.updateTableSequence(connection, tablename, keyColumnName, sequenceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateTableSequence(Connection connection, String tableName, String keyColumnName, String sequenceName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            String tableMaxIdSQL = "SELECT max(" + keyColumnName + ") as NB FROM " + tableName;
            long maxId = 0L;
            try (ResultSet tableMaxIdResultSet = statement.executeQuery(tableMaxIdSQL);){
                if (tableMaxIdResultSet.next()) {
                    maxId = tableMaxIdResultSet.getLong(1);
                }
                if (maxId == 0L) {
                    Log.debug((String)"geonetwork.database", (Object)("  Table " + tableName + " does not have any data. Skipping sequence " + sequenceName + " update"));
                    return;
                }
                Log.debug((String)"geonetwork.database", (Object)("  Max id for table " + tableName + " : " + maxId + ". Related sequence: " + sequenceName));
            }
            UpdateAllSequenceValueToMax.updateSequence(connection, sequenceName, maxId);
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.database", (Object)("  Exception while updating sequence " + sequenceName + " . Error is: " + e.getMessage()));
            Log.error((String)"geonetwork.database", (Object)e);
        }
    }

    private static void updateSequence(Connection connection, String sequenceName, long desiredVal) throws SQLException {
        DatabaseMetaDataDialectResolutionInfoAdapter dialectResolutionInfo = new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData());
        Dialect dialect = new StandardDialectResolver().resolveDialect((DialectResolutionInfo)dialectResolutionInfo);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long currval = 0L;
        long loopCount = 0L;
        try {
            preparedStatement = connection.prepareStatement(dialect.getSequenceNextValString(sequenceName));
            while (currval < desiredVal && (resultSet = preparedStatement.executeQuery()).next()) {
                currval = resultSet.getLong(1);
                ++loopCount;
                resultSet.close();
                resultSet = null;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        Log.debug((String)"geonetwork.database", (Object)("  Sequence " + sequenceName + " updated. Increased by: " + loopCount + ".  Currval: " + currval));
    }

    public static String getFieldName(Method method) {
        try {
            PropertyDescriptor[] props;
            Class<?> clazz = method.getDeclaringClass();
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : props = info.getPropertyDescriptors()) {
                if (!method.equals(pd.getWriteMethod()) && !method.equals(pd.getReadMethod())) continue;
                return pd.getName();
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

