/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.proxy;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.domain.mapservices.MapService;
import org.fao.geonet.kernel.security.SecurityProviderConfiguration;
import org.fao.geonet.kernel.security.SecurityProviderUtil;
import org.fao.geonet.repository.LinkRepository;
import org.fao.geonet.repository.MetadataLinkRepository;
import org.fao.geonet.repository.specification.LinkSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;

public class URITemplateProxyServlet
extends org.mitre.dsmiley.httpproxy.URITemplateProxyServlet {
    private static final long serialVersionUID = 4847856943273604410L;
    private static final String P_SECURITY_MODE = "securityMode";
    public static final String P_FORWARDEDHOST = "forwardHost";
    public static final String P_FORWARDEDHOSTPREFIXPATH = "forwardHostPrefixPath";
    protected boolean doForwardHost = false;
    protected String doForwardHostPrefixPath = "";
    protected SECURITY_MODE securityMode;
    @Autowired
    MetadataLinkRepository metadataLinkRepository;

    protected void initTarget() throws ServletException {
        this.securityMode = SECURITY_MODE.parse(this.getConfigParam(P_SECURITY_MODE));
        String doForwadHostString = this.getConfigParam(P_FORWARDEDHOST);
        if (doForwadHostString != null) {
            String doForwadHostPrefixPathString = this.getConfigParam(P_FORWARDEDHOSTPREFIXPATH);
            this.doForwardHost = Boolean.parseBoolean(doForwadHostString);
            this.doForwardHostPrefixPath = doForwadHostPrefixPathString != null ? doForwadHostPrefixPathString : "";
        }
        super.initTarget();
    }

    protected HttpClient createHttpClient(RequestConfig requestConfig) {
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).useSystemProperties().build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        List mapServiceList;
        Optional<MapService> result;
        super.copyRequestHeaders(servletRequest, proxyRequest);
        if (this.doForwardHost) {
            StringBuffer url = servletRequest.getRequestURL();
            String uri = servletRequest.getRequestURI();
            String host = url.substring(servletRequest.getScheme().length() + 3, url.indexOf(uri));
            proxyRequest.setHeader("X-Forwarded-Host", host);
            proxyRequest.setHeader("X-Forwarded-Proto", servletRequest.getScheme());
            proxyRequest.setHeader("X-Forwarded-Prefix", servletRequest.getContextPath() + this.doForwardHostPrefixPath);
        }
        if (!StringUtils.isEmpty((CharSequence)servletRequest.getHeader("Authorization")) || !(result = (mapServiceList = (List)ApplicationContextHolder.get().getBean("securedMapServices", List.class)).stream().filter(u -> MapService.UrlType.valueOf((String)u.getUrlType()).equals((Object)MapService.UrlType.TEXT) && proxyRequest.getRequestLine().getUri().contains(u.getUrl()) || MapService.UrlType.valueOf((String)u.getUrlType()).equals((Object)MapService.UrlType.REGEXP) && proxyRequest.getRequestLine().getUri().matches(u.getUrl())).findFirst()).isPresent()) return;
        if (MapService.AuthType.valueOf((String)result.get().getAuthType()).equals((Object)MapService.AuthType.BASIC)) {
            proxyRequest.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((result.get().getUsername() + ":" + result.get().getPassword()).getBytes()));
            return;
        } else {
            if (!MapService.AuthType.valueOf((String)result.get().getAuthType()).equals((Object)MapService.AuthType.BEARER)) throw new IllegalArgumentException("Unknown authentication type " + result.get().getAuthType());
            if (!SecurityContextHolder.getContext().getAuthentication().isAuthenticated()) return;
            SecurityProviderUtil securityProviderUtil = SecurityProviderConfiguration.getSecurityProviderUtil();
            if (securityProviderUtil == null) throw new IllegalArgumentException("Invalid or Unsupported authentication type " + result.get().getAuthType() + " for current security provider");
            String authenticationHeaderValue = securityProviderUtil.getSSOAuthenticationHeaderValue();
            if (StringUtils.isEmpty((CharSequence)authenticationHeaderValue)) return;
            proxyRequest.setHeader("Authorization", authenticationHeaderValue);
        }
    }

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        switch (this.securityMode) {
            case NONE: {
                super.service(servletRequest, servletResponse);
                break;
            }
            case DB_LINK_CHECK: {
                boolean proxyCallAllowed = false;
                try {
                    UserSession userSession = ApiUtils.getUserSession((HttpSession)servletRequest.getSession());
                    if (userSession.isAuthenticated()) {
                        proxyCallAllowed = true;
                    }
                }
                catch (SecurityException securityException) {
                    servletResponse.sendError(403, securityException.getMessage());
                }
                if (!proxyCallAllowed && this.securityMode == SECURITY_MODE.DB_LINK_CHECK) {
                    try {
                        URI uri = new URI(servletRequest.getParameter("url"));
                        String host = uri.getHost();
                        LinkRepository linkRepository = (LinkRepository)ApplicationContextHolder.get().getBean(LinkRepository.class);
                        long linksFound = linkRepository.count(LinkSpecs.filter((String)host, null, null, null, null, null));
                        if (linksFound == 0L) {
                            String message = String.format("The proxy does not allow to access '%s' because the URL host was not registered in any metadata records.", uri);
                            if (linkRepository.count() == 0L) {
                                servletResponse.sendError(403, "The proxy is configured with DB_LINK_CHECK mode but the MetadataLink table is empty. Administrator may need to analyze record links from the admin console in order to register URL allowed by the proxy. " + message);
                            }
                            servletResponse.sendError(403, message);
                        }
                        proxyCallAllowed = linksFound > 0L;
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException(String.format("'%s' is invalid. Error is: '%s'", e.getMessage()));
                    }
                }
                if (!proxyCallAllowed) break;
                super.service(servletRequest, servletResponse);
            }
        }
    }

    static {
        String[] headers;
        for (String header : headers = new String[]{"X-XSRF-TOKEN", "Access-Control-Allow-Origin", "Vary", "Access-Control-Allow-Credentials", "Strict-Transport-Security", "Etag"}) {
            hopByHopHeaders.addHeader((Header)new BasicHeader(header, null));
        }
    }

    private static enum SECURITY_MODE {
        NONE,
        DB_LINK_CHECK;


        public static SECURITY_MODE parse(String value) {
            if ("DB_LINK_CHECK".equals(value)) {
                return DB_LINK_CHECK;
            }
            return NONE;
        }
    }
}

