/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.i18n;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fao.geonet.NodeInfo;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.util.Assert;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.support.RequestContextUtils;

public class UrlLocaleChangeInterceptor
extends HandlerInterceptorAdapter {
    public static final Integer DEFAULT_URL_POSITION = 2;
    private Integer urlPosition = DEFAULT_URL_POSITION;

    public void setUrlPosition(Integer p) {
        Assert.isTrue((p > 0 ? 1 : 0) != 0, (String)"urlPosition must be greater than 0");
        this.urlPosition = p;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String pathAfterContext = request.getRequestURI().substring(request.getContextPath().length());
        String[] path = pathAfterContext.split("/");
        if (this.urlPosition >= path.length || path.length > 1 && NodeInfo.EXCLUDED_NODE_IDS.contains((Object)path[1]) || path.length > 2 && "api".equals(path[2])) {
            return true;
        }
        String localeCode = path[this.urlPosition];
        if (localeCode != null) {
            LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
            if (localeResolver == null) {
                throw new IllegalStateException("No LocaleResolver found: not in a DispatcherServlet request?");
            }
            LocaleEditor localeEditor = new LocaleEditor();
            localeEditor.setAsText(localeCode);
            localeResolver.setLocale(request, response, (Locale)localeEditor.getValue());
        }
        return true;
    }
}

