/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class NamespaceUtils {
    public static List<Namespace> getNamespacesInScope(Element element) {
        Element pnt;
        TreeMap<String, Namespace> namespaces = new TreeMap<String, Namespace>();
        namespaces.put(Namespace.XML_NAMESPACE.getPrefix(), Namespace.XML_NAMESPACE);
        namespaces.put(element.getNamespacePrefix(), element.getNamespace());
        if (element.getAdditionalNamespaces() != null) {
            for (Object nso : element.getAdditionalNamespaces()) {
                Namespace ns = (Namespace)nso;
                if (namespaces.containsKey(ns.getPrefix())) continue;
                namespaces.put(ns.getPrefix(), ns);
            }
        }
        if (element.getAttributes() != null) {
            for (Iterator<Object> attO : element.getAttributes()) {
                Attribute att = (Attribute)attO;
                Namespace ns = att.getNamespace();
                if (namespaces.containsKey(ns.getPrefix())) continue;
                namespaces.put(ns.getPrefix(), ns);
            }
        }
        if ((pnt = element.getParentElement()) != null) {
            for (Namespace ns : NamespaceUtils.getNamespacesInScope(pnt)) {
                if (namespaces.containsKey(ns.getPrefix())) continue;
                namespaces.put(ns.getPrefix(), ns);
            }
        }
        if (pnt == null && !namespaces.containsKey("")) {
            namespaces.put(Namespace.NO_NAMESPACE.getPrefix(), Namespace.NO_NAMESPACE);
        }
        ArrayList<Object> al = new ArrayList<Object>(namespaces.size());
        al.add(element.getNamespace());
        namespaces.remove(element.getNamespacePrefix());
        al.addAll(namespaces.values());
        return Collections.unmodifiableList(al);
    }

    public static List<Namespace> getNamespacesInherited(Element element) {
        if (element.getParentElement() == null) {
            ArrayList<Namespace> ret = new ArrayList<Namespace>(NamespaceUtils.getNamespacesInScope(element));
            Iterator it = ret.iterator();
            while (it.hasNext()) {
                Namespace ns = (Namespace)it.next();
                if (ns == Namespace.NO_NAMESPACE || ns == Namespace.XML_NAMESPACE) continue;
                it.remove();
            }
            return Collections.unmodifiableList(ret);
        }
        HashMap<String, Namespace> parents = new HashMap<String, Namespace>();
        for (Namespace ns : NamespaceUtils.getNamespacesInScope(element.getParentElement())) {
            parents.put(ns.getPrefix(), ns);
        }
        ArrayList<Namespace> al = new ArrayList<Namespace>();
        for (Namespace ns : NamespaceUtils.getNamespacesInScope(element)) {
            if (ns != parents.get(ns.getPrefix())) continue;
            al.add(ns);
        }
        return Collections.unmodifiableList(al);
    }

    public static List<Namespace> getNamespacesIntroduced(Element element) {
        if (element.getParentElement() == null) {
            ArrayList<Namespace> ret = new ArrayList<Namespace>(NamespaceUtils.getNamespacesInScope(element));
            Iterator it = ret.iterator();
            while (it.hasNext()) {
                Namespace ns = (Namespace)it.next();
                if (ns != Namespace.XML_NAMESPACE && ns != Namespace.NO_NAMESPACE) continue;
                it.remove();
            }
            return Collections.unmodifiableList(ret);
        }
        HashMap<String, Namespace> parents = new HashMap<String, Namespace>();
        for (Namespace ns : NamespaceUtils.getNamespacesInScope(element.getParentElement())) {
            parents.put(ns.getPrefix(), ns);
        }
        ArrayList<Namespace> al = new ArrayList<Namespace>();
        for (Namespace ns : NamespaceUtils.getNamespacesInScope(element)) {
            if (parents.containsKey(ns.getPrefix()) && ns == parents.get(ns.getPrefix())) continue;
            al.add(ns);
        }
        return Collections.unmodifiableList(al);
    }
}

