/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Optional;
import javax.servlet.ServletContext;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Constants;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserSecurityNotification;
import org.fao.geonet.exceptions.UserNotFoundEx;
import org.fao.geonet.repository.UserRepository;
import org.springframework.context.ApplicationContext;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PasswordUtil {
    public static final String ENCODER_ID = "geonetworkEncoder";
    public static final String PASSWORD_COLUMN = "password";

    public static boolean hasOldHash(User user) {
        return user.getSecurity().getSecurityNotifications().contains(UserSecurityNotification.UPDATE_HASH_REQUIRED);
    }

    public static boolean matchesAnyHash(PasswordEncoder encoder, String hash, String password) {
        return PasswordUtil.matchesOldHash(hash, password) || encoder.matches((CharSequence)password, hash);
    }

    public static boolean matchesOldHash(String hash, String password) {
        return PasswordUtil.unsaltedScramble(password).equals(hash) || PasswordUtil.oldScramble(password).equals(hash);
    }

    private static String unsaltedScramble(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(text.getBytes(Constants.ENCODING));
            byte[] raw = md.digest();
            if (raw == null) {
                return null;
            }
            StringBuilder hex = new StringBuilder(2 * raw.length);
            for (byte b : raw) {
                hex.append("0123456789abcdef".charAt((b & 0xF0) >> 4)).append("0123456789abcdef".charAt(b & 0xF));
            }
            return hex.toString();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static String oldScramble(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(text.getBytes(Constants.ENCODING));
            StringBuffer sb = new StringBuffer();
            for (byte b : md.digest()) {
                sb.append(Integer.toString(b & 0xFF, 16));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static PasswordEncoder encoder(ServletContext servletContext) {
        WebApplicationContext appcontext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return (PasswordEncoder)appcontext.getBean(ENCODER_ID);
    }

    public static PasswordEncoder encoder(ApplicationContext appContext) {
        return (PasswordEncoder)appContext.getBean(ENCODER_ID);
    }

    public static User updatePasswordWithNew(boolean matchOldPassword, String oldPassword, String newPassword, Integer iUserId, ApplicationContext appContext) throws SQLException, UserNotFoundEx {
        UserRepository repo = (UserRepository)appContext.getBean(UserRepository.class);
        Optional user = repo.findById((Object)iUserId);
        if (user.isPresent()) {
            throw new UserNotFoundEx("" + iUserId);
        }
        PasswordEncoder encoder = PasswordUtil.encoder(appContext);
        return PasswordUtil.updatePasswordWithNew(matchOldPassword, oldPassword, newPassword, (User)user.get(), encoder, repo);
    }

    public static User updatePasswordWithNew(boolean matchOldPassword, String oldPassword, String newPassword, User user, PasswordEncoder encoder, UserRepository repository) throws SQLException, UserNotFoundEx {
        String hash = user.getPassword();
        if (PasswordUtil.hasOldHash(user)) {
            if ((matchOldPassword || newPassword != null) && !PasswordUtil.matchesOldHash(hash, newPassword)) {
                throw new IllegalArgumentException("Password is not correct. It does not match old hash.");
            }
        } else if ((matchOldPassword || oldPassword != null) && !encoder.matches((CharSequence)oldPassword, hash)) {
            throw new IllegalArgumentException("Old password is not correct");
        }
        user.getSecurity().getSecurityNotifications().remove(UserSecurityNotification.UPDATE_HASH_REQUIRED);
        String newPasswordHash = encoder.encode((CharSequence)newPassword);
        user.getSecurity().setPassword(newPasswordHash.toCharArray());
        repository.save((Object)user);
        return user;
    }

    public static String encode(ServiceContext context, String password) {
        return PasswordUtil.encoder((ApplicationContext)context.getApplicationContext()).encode((CharSequence)password);
    }
}

