/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;

public class MailUtil {
    public static final String LOG_MODULE_NAME = "geonetwork";

    public static Boolean sendHtmlMail(List<String> toAddress, String subject, String htmlMessage, SettingManager settings) {
        HtmlEmail email = new HtmlEmail();
        MailUtil.configureBasics(settings, (Email)email);
        email.setSubject(subject);
        try {
            email.setHtmlMsg(htmlMessage);
        }
        catch (EmailException e1) {
            Log.error((String)("Error setting email HTML content. Subject:" + subject), (Object)((Object)e1));
            return false;
        }
        for (String add : toAddress) {
            try {
                email.addBcc(add);
            }
            catch (EmailException e) {
                Log.error((String)LOG_MODULE_NAME, (Object)("Error setting email BCC address " + add), (Throwable)e);
                return false;
            }
        }
        return MailUtil.send((Email)email);
    }

    public static Boolean sendMail(List<String> toAddress, String subject, String message, SettingManager settings) {
        SimpleEmail email = new SimpleEmail();
        MailUtil.configureBasics(settings, (Email)email);
        email.setSubject(subject);
        try {
            email.setMsg(message);
        }
        catch (EmailException e1) {
            Log.error((String)LOG_MODULE_NAME, (Object)"Error setting email message", (Throwable)e1);
            return false;
        }
        for (String add : toAddress) {
            try {
                email.addBcc(add);
            }
            catch (EmailException e) {
                Log.error((String)LOG_MODULE_NAME, (Object)("Error setting email BCC address " + add), (Throwable)e);
            }
        }
        return MailUtil.send((Email)email);
    }

    public static Boolean sendMail(List<String> toAddress, String subject, String message, String htmlMessage, SettingManager settings, String replyTo, String replyToDesc) {
        boolean isHtml = StringUtils.isNotBlank((String)htmlMessage);
        HtmlEmail email = isHtml ? new HtmlEmail() : new SimpleEmail();
        MailUtil.configureBasics(settings, (Email)email);
        ArrayList<InternetAddress> addressColl = new ArrayList<InternetAddress>();
        if (StringUtils.isNotEmpty((String)replyTo)) {
            try {
                addressColl.add(new InternetAddress(replyTo, replyToDesc));
                email.setReplyTo(addressColl);
            }
            catch (UnsupportedEncodingException e2) {
                Log.error((String)LOG_MODULE_NAME, (Object)("Error setting email replyTo. Characters not supported in \"" + replyToDesc + "\""), (Throwable)e2);
                return false;
            }
            catch (EmailException e) {
                Log.error((String)LOG_MODULE_NAME, (Object)("Error setting email replyTo. Invalid email address \"" + replyTo + "\""), (Throwable)e);
                return false;
            }
        }
        email.setSubject(subject);
        try {
            if (StringUtils.isNotBlank((String)message)) {
                email.setMsg(message);
            }
            if (isHtml) {
                email.setHtmlMsg(htmlMessage);
            }
        }
        catch (EmailException e1) {
            Log.error((String)LOG_MODULE_NAME, (Object)"Error setting email message", (Throwable)e1);
            return false;
        }
        for (String add : toAddress) {
            try {
                email.addBcc(add);
            }
            catch (EmailException e) {
                Log.error((String)LOG_MODULE_NAME, (Object)("Error setting email BCC address " + add), (Throwable)e);
            }
        }
        return MailUtil.send((Email)email);
    }

    public static Boolean sendHtmlMailWithAttachment(List<String> toAddress, String from, String subject, String htmlMessage, List<EmailAttachment> attachment, SettingManager settings) {
        HtmlEmail email = new HtmlEmail();
        String username = settings.getValue("system/feedback/mailServer/username");
        String password = settings.getValue("system/feedback/mailServer/password");
        Boolean ssl = settings.getValueAsBool("system/feedback/mailServer/ssl", false);
        Boolean tls = settings.getValueAsBool("system/feedback/mailServer/tls", false);
        String hostName = settings.getValue("system/feedback/mailServer/host");
        Integer smtpPort = Integer.valueOf(settings.getValue("system/feedback/mailServer/port"));
        Boolean ignoreSslCertificateErrors = settings.getValueAsBool("system/feedback/mailServer/ignoreSslCertificateErrors", false);
        MailUtil.configureBasics(hostName, smtpPort, from, username, password, (Email)email, ssl, tls, ignoreSslCertificateErrors);
        for (EmailAttachment attach : attachment) {
            try {
                email.attach(attach);
            }
            catch (EmailException e) {
                Log.error((String)LOG_MODULE_NAME, (Object)("Error attaching attachment " + attach.getName()), (Throwable)e);
            }
        }
        email.setSubject(subject);
        try {
            email.setHtmlMsg(htmlMessage);
        }
        catch (EmailException e1) {
            Log.error((String)LOG_MODULE_NAME, (Object)"Error setting email HTML message", (Throwable)e1);
            return false;
        }
        for (String add : toAddress) {
            try {
                email.addBcc(add);
            }
            catch (EmailException e) {
                Log.error((String)LOG_MODULE_NAME, (Object)("Error setting email BCC address " + add), (Throwable)e);
                return false;
            }
        }
        return MailUtil.send((Email)email);
    }

    private static Boolean send(Email email) {
        try {
            email.send();
        }
        catch (EmailException e) {
            Log.error((String)LOG_MODULE_NAME, (Object)("Error sending email \"" + email.getSubject() + "\""), (Throwable)e);
            return false;
        }
        return true;
    }

    private static void sendWithThread(final @Nonnull Email email) {
        try {
            Thread t = new Thread(){

                @Override
                public void run() {
                    super.run();
                    try {
                        email.send();
                    }
                    catch (EmailException e) {
                        Log.error((String)MailUtil.LOG_MODULE_NAME, (Object)("Error sending email \"" + email.getSubject() + "\" unsing other thread"), (Throwable)e);
                    }
                }
            };
            t.start();
        }
        catch (Exception e) {
            Log.error((String)LOG_MODULE_NAME, (Object)("Error sending email \"" + email.getSubject() + "\" unsing other thread"), (Throwable)e);
        }
    }

    public static Boolean sendMail(List<String> toAddress, String from, String subject, String message, SettingManager settings) {
        SimpleEmail email = new SimpleEmail();
        String username = settings.getValue("system/feedback/mailServer/username");
        String password = settings.getValue("system/feedback/mailServer/password");
        Boolean ssl = settings.getValueAsBool("system/feedback/mailServer/ssl", false);
        Boolean tls = settings.getValueAsBool("system/feedback/mailServer/tls", false);
        String hostName = settings.getValue("system/feedback/mailServer/host");
        Integer smtpPort = Integer.valueOf(settings.getValue("system/feedback/mailServer/port"));
        Boolean ignoreSslCertificateErrors = settings.getValueAsBool("system/feedback/mailServer/ignoreSslCertificateErrors", false);
        MailUtil.configureBasics(hostName, smtpPort, from, username, password, (Email)email, ssl, tls, ignoreSslCertificateErrors);
        email.setSubject(subject);
        try {
            email.setMsg(message);
        }
        catch (EmailException e1) {
            Log.error((String)LOG_MODULE_NAME, (Object)"Error setting email message", (Throwable)e1);
            return false;
        }
        for (String add : toAddress) {
            try {
                email.addBcc(add);
            }
            catch (EmailException e) {
                Log.error((String)LOG_MODULE_NAME, (Object)("Error setting email BCC address " + add), (Throwable)e);
                return false;
            }
        }
        return MailUtil.send((Email)email);
    }

    private static void configureBasics(String hostName, Integer smtpPort, String from, String username, String password, Email email, Boolean ssl, Boolean tls, Boolean ignoreSslCertificateErrors) {
        if (hostName == null) {
            throw new IllegalArgumentException("Missing settings in System Configuration (see Administration menu) - cannot send mail");
        }
        email.setHostName(hostName);
        if (!StringUtils.isNotBlank((String)(smtpPort + ""))) {
            throw new IllegalArgumentException("Missing settings in System Configuration (see Administration menu) - cannot send mail");
        }
        email.setSmtpPort(smtpPort.intValue());
        if (StringUtils.isNotEmpty((String)username)) {
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(username, password));
        }
        email.setDebug(true);
        if (tls != null && tls.booleanValue()) {
            email.setStartTLSEnabled(tls.booleanValue());
            email.setStartTLSRequired(tls.booleanValue());
        }
        if (ssl != null && ssl.booleanValue()) {
            email.setSSLOnConnect(ssl.booleanValue());
            if (StringUtils.isNotBlank((String)(smtpPort + ""))) {
                email.setSslSmtpPort(smtpPort + "");
            }
        }
        if (ignoreSslCertificateErrors != null && ignoreSslCertificateErrors.booleanValue()) {
            try {
                Session mailSession = email.getMailSession();
                Properties p = mailSession.getProperties();
                p.setProperty("mail.smtp.ssl.trust", "*");
            }
            catch (EmailException mailSession) {
                // empty catch block
            }
        }
        if (StringUtils.isNotBlank((String)from)) {
            try {
                email.setFrom(from);
            }
            catch (EmailException e) {
                throw new IllegalArgumentException("Invalid 'from' email setting in System Configuration (see Administration menu) - cannot send mail", e);
            }
        } else {
            throw new IllegalArgumentException("Missing settings in System Configuration (see Administration menu) - cannot send mail");
        }
    }

    private static void configureBasics(SettingManager settings, Email email) {
        String username = settings.getValue("system/feedback/mailServer/username");
        String password = settings.getValue("system/feedback/mailServer/password");
        Boolean ssl = settings.getValueAsBool("system/feedback/mailServer/ssl", false);
        Boolean tls = settings.getValueAsBool("system/feedback/mailServer/tls", false);
        String hostName = settings.getValue("system/feedback/mailServer/host");
        Integer smtpPort = Integer.valueOf(settings.getValue("system/feedback/mailServer/port"));
        String from = settings.getValue("system/feedback/email");
        Boolean ignoreSslCertificateErrors = settings.getValueAsBool("system/feedback/mailServer/ignoreSslCertificateErrors", false);
        MailUtil.configureBasics(hostName, smtpPort, from, username, password, email, ssl, tls, ignoreSslCertificateErrors);
    }

    public static Boolean sendMail(String email, String subject, String message, String htmlMessage, SettingManager sm) {
        ArrayList<String> to = new ArrayList<String>(1);
        to.add(email);
        return MailUtil.sendMail(to, subject, message, htmlMessage, sm, null, null);
    }

    public static Boolean sendMail(String to, String subject, String message, String htmlMessage, SettingManager sm, String replyTo, String replyToDescr) {
        ArrayList<String> to_ = new ArrayList<String>(1);
        to_.add(to);
        return MailUtil.sendMail(to_, subject, message, htmlMessage, sm, replyTo, replyToDescr);
    }

    public static void testSendMail(String to, String subject, String message, String htmlMessage, SettingManager sm, String replyTo, String replyToDescr) throws Exception {
        ArrayList<String> to_ = new ArrayList<String>(1);
        to_.add(to);
        MailUtil.testSendMail(to_, subject, message, htmlMessage, sm, replyTo, replyToDescr);
    }

    public static void testSendMail(List<String> toAddress, String subject, String message, String htmlMessage, SettingManager settings, String replyTo, String replyToDesc) throws Exception {
        boolean isHtml = StringUtils.isNotBlank((String)htmlMessage);
        HtmlEmail email = isHtml ? new HtmlEmail() : new SimpleEmail();
        MailUtil.configureBasics(settings, (Email)email);
        ArrayList<InternetAddress> addressColl = new ArrayList<InternetAddress>();
        addressColl.add(new InternetAddress(replyTo, replyToDesc));
        email.setReplyTo(addressColl);
        email.setSubject(subject);
        if (StringUtils.isNotBlank((String)message)) {
            email.setMsg(message);
        }
        if (isHtml) {
            email.setHtmlMsg(htmlMessage);
        }
        for (String add : toAddress) {
            email.addBcc(add);
        }
        email.send();
    }
}

