/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.lib;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import jeeves.server.context.ServiceContext;
import jeeves.transaction.TransactionManager;
import jeeves.transaction.TransactionTask;
import org.fao.geonet.Constants;
import org.fao.geonet.lib.DatabaseType;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.TransactionStatus;

public class DbLib {
    private static final String SQL_EXTENSION = ".sql";

    public void insertData(ServletContext servletContext, ServiceContext context, Path appPath, Path filePath, String filePrefix) throws Exception {
        if (Log.isDebugEnabled((String)"geonetwork.database")) {
            Log.debug((String)"geonetwork.database", (Object)"Filling database tables");
        }
        List<String> data = this.loadSqlDataFile(servletContext, (ApplicationContext)context.getApplicationContext(), appPath, filePath, filePrefix);
        DbLib.runSQL(context, data);
    }

    public static void runSQL(final ServiceContext context, final List<String> data) {
        TransactionManager.runInTransaction("Apply SQL statements in database", (ApplicationContext)context.getApplicationContext(), TransactionManager.TransactionRequirement.CREATE_ONLY_WHEN_NEEDED, TransactionManager.CommitBehavior.ALWAYS_COMMIT, false, new TransactionTask<Object>(){

            @Override
            public Object doInTransaction(TransactionStatus transaction) throws Throwable {
                DbLib.runSQL(context.getEntityManager(), data, true);
                return null;
            }
        });
    }

    public void insertData(ServletContext servletContext, Statement statement, Path appPath, Path filePath, String filePrefix) throws Exception {
        if (Log.isDebugEnabled((String)"geonetwork.database")) {
            Log.debug((String)"geonetwork.database", (Object)"Filling database tables");
        }
        List<String> data = this.loadSqlDataFile(servletContext, statement, appPath, filePath, filePrefix);
        this.runSQL(statement, data, true);
    }

    private static void runSQL(EntityManager entityManager, List<String> data, boolean failOnError) throws Exception {
        StringBuffer sb = new StringBuffer();
        boolean inBlock = false;
        for (String row : data) {
            block9: {
                if (row.toUpperCase().startsWith("REM") || row.startsWith("--") || row.trim().equals("")) continue;
                sb.append(" ");
                sb.append(row);
                if (!inBlock && row.contains("BEGIN")) {
                    inBlock = true;
                } else if (inBlock && row.contains("END")) {
                    inBlock = false;
                }
                if (inBlock || !row.endsWith(";")) continue;
                String sql = sb.toString();
                sql = sql.substring(0, sql.length() - 1);
                if (Log.isDebugEnabled((String)"geonetwork.database")) {
                    Log.debug((String)"geonetwork.database", (Object)("Executing " + sql));
                }
                try {
                    String trimmedSQL = sql.trim();
                    Query query = entityManager.createNativeQuery(trimmedSQL);
                    if (trimmedSQL.startsWith("SELECT")) {
                        query.setMaxResults(1);
                        query.getSingleResult();
                    } else {
                        query.executeUpdate();
                    }
                }
                catch (Throwable e) {
                    Log.warning((String)"geonetwork.database", (Object)("SQL failure for: " + sql + ", error is:" + e.getMessage()), (Throwable)e);
                    if (!failOnError) break block9;
                    throw new RuntimeException(e);
                }
            }
            sb = new StringBuffer();
        }
        entityManager.flush();
        entityManager.clear();
    }

    private void runSQL(Statement statement, List<String> data, boolean failOnError) throws Exception {
        StringBuffer sb = new StringBuffer();
        boolean inBlock = false;
        for (String row : data) {
            block9: {
                if (row.toUpperCase().startsWith("REM") || row.startsWith("--") || row.trim().equals("")) continue;
                sb.append(" ");
                sb.append(row);
                if (!inBlock && row.contains("BEGIN")) {
                    inBlock = true;
                } else if (inBlock && row.contains("END")) {
                    inBlock = false;
                }
                if (inBlock || !row.endsWith(";")) continue;
                String sql = sb.toString();
                sql = sql.substring(0, sql.length() - 1);
                if (Log.isDebugEnabled((String)"geonetwork.database")) {
                    Log.debug((String)"geonetwork.database", (Object)("Executing " + sql));
                }
                try {
                    if (sql.trim().startsWith("SELECT")) {
                        statement.executeQuery(sql).close();
                    } else {
                        statement.execute(sql);
                    }
                }
                catch (SQLException e) {
                    Log.warning((String)"geonetwork.database", (Object)("SQL failure for: " + sql + ", error is:" + e.getMessage()));
                    if (!failOnError) break block9;
                    throw e;
                }
            }
            sb = new StringBuffer();
        }
        statement.getConnection().commit();
    }

    private Path checkFilePath(ServletContext servletContext, Path appPath, Path filePath, String prefix, String type) {
        String realPath;
        Path finalPath = this.testPath(filePath.resolve(prefix + type + SQL_EXTENSION));
        if (finalPath == null) {
            finalPath = this.testPath(appPath.resolve(filePath).resolve(prefix + type + SQL_EXTENSION));
        }
        if (finalPath == null && servletContext != null && (realPath = servletContext.getRealPath(filePath.resolve(prefix + type + SQL_EXTENSION).toString())) != null) {
            finalPath = this.testPath(this.toPath(realPath));
        }
        if (finalPath == null) {
            finalPath = this.testPath(filePath.resolve(prefix + "default" + SQL_EXTENSION));
        }
        if (finalPath == null) {
            finalPath = this.testPath(appPath.resolve(filePath.resolve(prefix + "default" + SQL_EXTENSION)));
        }
        if (finalPath == null && servletContext != null && (realPath = servletContext.getRealPath(filePath.resolve(prefix + "default" + SQL_EXTENSION).toString())) != null) {
            finalPath = this.testPath(this.toPath(realPath));
        }
        if (finalPath != null) {
            return finalPath;
        }
        Log.debug((String)"geonetwork.database", (Object)("  No default SQL script found: " + filePath + "/" + prefix + type + SQL_EXTENSION));
        return this.toPath("");
    }

    private Path toPath(String pathString) {
        try {
            return IO.toPath((String)pathString, (String[])new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    private Path testPath(Path dbFilePath) {
        if (dbFilePath != null && Files.exists(dbFilePath, new LinkOption[0])) {
            return dbFilePath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadSqlDataFile(ServletContext servletContext, ApplicationContext appContext, Path appPath, Path filePath, String filePrefix) throws IOException, SQLException {
        DataSource dataSource = (DataSource)appContext.getBean(DataSource.class);
        try (Connection connection = null;){
            connection = dataSource.getConnection();
            Path file = this.checkFilePath(servletContext, appPath, filePath, filePrefix, DatabaseType.lookup(connection).toString());
            List<String> list = Lib.text.load(servletContext, appPath, file, Constants.ENCODING);
            return list;
        }
    }

    private List<String> loadSqlDataFile(ServletContext servletContext, Statement statement, Path appPath, Path filePath, String filePrefix) throws IOException, SQLException {
        Path file = this.checkFilePath(servletContext, appPath, filePath, filePrefix, DatabaseType.lookup(statement.getConnection()).toString());
        return Lib.text.load(servletContext, appPath, file, Constants.ENCODING);
    }
}

