/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.lib;

import java.sql.Connection;
import java.sql.SQLException;

public enum DatabaseType {
    defaultType(null),
    sqlserver("jdbc:sqlserver:"),
    postgis("jdbc:postgresql_postGIS:"),
    postgres("jdbc:postgresql:"),
    mysql("jdbc:mysql:"),
    db2("jdbc:db2:"),
    mckoi("jdbc:mckoi:"),
    oracle("jdbc:oracle:");

    private final String urlPrefix;

    private DatabaseType(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public static DatabaseType lookup(Connection dbms) throws SQLException {
        String url = dbms.getMetaData().getURL();
        if (url == null) {
            return defaultType;
        }
        for (DatabaseType dbType : DatabaseType.values()) {
            if (dbType == defaultType || !url.startsWith(dbType.urlPrefix)) continue;
            return dbType;
        }
        return defaultType;
    }

    public String toString() {
        if (this == defaultType) {
            return "default";
        }
        return super.toString();
    }
}

