/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.region;

import com.google.common.base.Optional;
import java.util.Collection;
import org.fao.geonet.kernel.region.Region;
import org.jdom.Content;
import org.jdom.Element;

public abstract class Request {
    public static final String REGIONS_EL = "regions";
    private static final String COUNT_ATT = "count";

    public abstract Request label(String var1);

    public abstract Request categoryId(String var1);

    public abstract Request maxRecords(int var1);

    public abstract Collection<Region> execute() throws Exception;

    public abstract Request id(String var1);

    public Region get() throws Exception {
        Collection<Region> regions = this.execute();
        if (regions.size() > 1) {
            throw new IllegalStateException("there is more than one region found");
        }
        if (regions.isEmpty()) {
            return null;
        }
        return regions.iterator().next();
    }

    public Element xmlResult() throws Exception {
        Collection<Region> regions = this.execute();
        Element result = new Element(REGIONS_EL).setAttribute("class", "array");
        result.setAttribute(COUNT_ATT, Integer.toString(regions.size()));
        for (Region region : regions) {
            result.addContent((Content)region.toElement());
        }
        return result;
    }

    public abstract Optional<Long> getLastModified() throws Exception;
}

