/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.template;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.records.formatters.groovy.template.TNode;
import org.fao.geonet.api.records.formatters.groovy.template.TNodeRepeatIter;
import org.fao.geonet.api.records.formatters.groovy.template.TRenderContext;
import org.fao.geonet.api.records.formatters.groovy.template.TemplateException;
import org.fao.geonet.api.records.formatters.groovy.template.TextContentParser;
import org.xml.sax.Attributes;

public class TNodeRepeatMap
extends TNode {
    private final String key;
    private final String rowKeyName;
    private final String rowValueName;
    private final boolean onlyChildren;

    public TNodeRepeatMap(SystemInfo info, TextContentParser parser, boolean onlyChildren, String qName, Attributes attributes, String key, String rowKeyName, String rowValueName) throws IOException {
        super(info, parser, qName, attributes);
        this.key = key;
        this.rowKeyName = rowKeyName;
        this.rowValueName = rowValueName;
        this.onlyChildren = onlyChildren;
    }

    @Override
    public void render(TRenderContext context) throws IOException {
        Object modelValue = context.getModelValue(this.key);
        if (!(modelValue instanceof Map)) {
            if (modelValue == null) {
                String options = Joiner.on((String)", ").join(context.getAllModelKeys());
                throw new TemplateException("There is no model item with the key: " + this.key + ".  Options include: " + options);
            }
            throw new TemplateException("Expected a map for (" + this.rowKeyName + ", " + this.rowValueName + ") in " + this.key + " but got a " + modelValue);
        }
        Map map = (Map)modelValue;
        if (map.isEmpty() && this.info.isDevMode()) {
            context.append("<!-- fmt-repeat: (").append(this.rowKeyName).append(", ").append(this.rowValueName).append(") in ").append(this.key).append(" is empty -->");
        }
        int i = 0;
        int size = map.size();
        for (Map.Entry entry : map.entrySet()) {
            HashMap newModelMap = Maps.newHashMap();
            newModelMap.put(this.rowKeyName, entry.getKey());
            newModelMap.put(this.rowValueName, entry.getValue());
            TNodeRepeatIter.addIndexInfo(newModelMap, i, size);
            TRenderContext childContext = context.childContext(newModelMap);
            if (!this.onlyChildren) {
                context.append("<").append(this.qName);
                this.attributes.render(childContext);
                context.append(">");
            }
            for (TNode node : this.getChildren()) {
                node.render(childContext);
            }
            if (!this.onlyChildren) {
                this.end.render(childContext);
            }
            ++i;
        }
    }

    @Override
    protected Attributes customAttributes(TRenderContext context) {
        return null;
    }

    @Override
    protected Optional<String> canRender(TRenderContext context) {
        return Optional.absent();
    }
}

