/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy;

import groovy.util.slurpersupport.GPathResult;
import java.util.Collection;
import java.util.Iterator;
import org.fao.geonet.api.records.formatters.groovy.Handler;
import org.fao.geonet.api.records.formatters.groovy.TransformationContext;
import org.fao.geonet.utils.Log;

public class Logging {
    static void debug(String message, GPathResult elem, Object ... objects) {
        if (Logging.isDebugMode()) {
            Object[] objs = new Object[objects.length + 1];
            System.arraycopy(objects, 0, objs, 1, objects.length);
            objs[0] = "'" + Logging.createPath(elem) + "'";
            Logging.debug(String.format(message, objs));
        }
    }

    static void debug(String message, Collection<GPathResult> elem, Object ... objects) {
        if (Logging.isDebugMode()) {
            Object[] objs = new Object[objects.length + 1];
            System.arraycopy(objects, 0, objs, 1, objects.length);
            StringBuilder builder = new StringBuilder();
            if (elem.isEmpty()) {
                builder.append("No Paths");
            } else {
                Iterator<GPathResult> iterator = elem.iterator();
                GPathResult first = iterator.next();
                builder.append(Logging.createPath(first));
                while (iterator.hasNext()) {
                    GPathResult next = iterator.next();
                    builder.append(",").append(next.name());
                }
            }
            objs[0] = "'" + builder + "'";
            Logging.debug(String.format(message, objs));
        }
    }

    public static boolean isDebugMode() {
        return Log.isDebugEnabled((String)"geonetwork.formatter");
    }

    public static String createPath(GPathResult element) {
        if (element == null) {
            return "null";
        }
        StringBuilder pathBuilder = new StringBuilder();
        Handler.createPath(element, pathBuilder);
        String rootPath = "";
        TransformationContext context = TransformationContext.getContext();
        if (context != null) {
            rootPath = context.getRootPath() + ">";
        }
        return rootPath + pathBuilder.toString();
    }

    static void debug(String message) {
        if (Logging.isDebugMode()) {
            Log.debug((String)"geonetwork.formatter", (Object)message);
        }
    }
}

