/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy;

import com.google.common.base.Optional;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.records.formatters.FormatType;
import org.fao.geonet.api.records.formatters.FormatterParams;
import org.fao.geonet.api.records.formatters.FormatterWidth;
import org.fao.geonet.api.records.formatters.groovy.Environment;
import org.fao.geonet.api.records.formatters.groovy.EnvironmentImpl;
import org.fao.geonet.api.records.formatters.groovy.MapConfig;
import org.fao.geonet.api.records.formatters.groovy.ParamValue;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.jdom.Element;
import org.springframework.security.core.Authentication;

public class EnvironmentProxy
implements Environment {
    private static final ThreadLocal<Environment> currentEnvironment = new InheritableThreadLocal<Environment>();

    public static void setCurrentEnvironment(FormatterParams fparams) {
        currentEnvironment.set(new EnvironmentImpl(fparams, (IsoLanguagesMapper)fparams.context.getBean(IsoLanguagesMapper.class)));
    }

    public static void clearContext() {
        currentEnvironment.set(null);
    }

    private static Environment get() {
        Environment env = currentEnvironment.get();
        if (env == null) {
            throw new AssertionError((Object)"The Environment object cannot be used at the moment, it can only be used during XML processing, not during the configuration stage.  It is accessible here only so that it is in scope in all handlers without having to pass it in as a parameter to all handlers and sorters and similar object used for XML processing");
        }
        return env;
    }

    @Override
    public String getLang3() {
        return EnvironmentProxy.get().getLang3();
    }

    @Override
    public String getLang2() {
        return EnvironmentProxy.get().getLang2();
    }

    @Override
    public int getMetadataId() {
        return EnvironmentProxy.get().getMetadataId();
    }

    @Override
    public String getMetadataUUID() {
        return EnvironmentProxy.get().getMetadataUUID();
    }

    @Override
    public String getResourceUrl() {
        return EnvironmentProxy.get().getResourceUrl();
    }

    @Override
    public String getLocalizedUrl() {
        return EnvironmentProxy.get().getLocalizedUrl();
    }

    @Override
    public Authentication getAuth() {
        return EnvironmentProxy.get().getAuth();
    }

    @Override
    public FormatType getFormatType() {
        return EnvironmentProxy.get().getFormatType();
    }

    @Override
    public FormatterWidth getEmbeddingWidth() {
        return EnvironmentProxy.get().getEmbeddingWidth();
    }

    @Override
    public Multimap<String, ParamValue> params() {
        return EnvironmentProxy.get().params();
    }

    @Override
    public ParamValue param(String paramName) {
        return EnvironmentProxy.get().param(paramName);
    }

    @Override
    public Collection<ParamValue> paramValues(String paramName) {
        return EnvironmentProxy.get().paramValues(paramName);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return EnvironmentProxy.get().getHeaders(name);
    }

    @Override
    public Optional<String> getHeader(String name) {
        return EnvironmentProxy.get().getHeader(name);
    }

    @Override
    public Element getMetadataElement() {
        return EnvironmentProxy.get().getMetadataElement();
    }

    @Override
    public Map<String, Collection<String>> getIndexInfo() throws Exception {
        return EnvironmentProxy.get().getIndexInfo();
    }

    @Override
    public ServiceContext getContext() {
        return EnvironmentProxy.get().getContext();
    }

    @Override
    public <T> T getBean(Class<T> clazz) {
        return EnvironmentProxy.get().getBean(clazz);
    }

    @Override
    public <T> T getBean(String name, Class<T> clazz) {
        return EnvironmentProxy.get().getBean(name, clazz);
    }

    @Override
    public MapConfig getMapConfiguration() {
        return EnvironmentProxy.get().getMapConfiguration();
    }

    @Override
    public boolean canEdit() throws Exception {
        return EnvironmentProxy.get().canEdit();
    }
}

