/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.NotImplementedException;
import org.fao.geonet.api.records.formatters.FormatType;
import org.fao.geonet.api.records.formatters.FormatterParams;
import org.fao.geonet.api.records.formatters.FormatterWidth;
import org.fao.geonet.api.records.formatters.groovy.Environment;
import org.fao.geonet.api.records.formatters.groovy.MapConfig;
import org.fao.geonet.api.records.formatters.groovy.ParamValue;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.jdom.Element;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.WebRequest;

public class EnvironmentImpl
implements Environment {
    private final String lang3;
    private final String lang2;
    private final String resourceUrl;
    private final Multimap<String, ParamValue> params = ArrayListMultimap.create();
    private final FormatType formatType;
    private final AbstractMetadata metadataInfo;
    private final String locUrl;
    private final Element jdomMetadata;
    private final ServiceContext serviceContext;
    private final WebRequest webRequest;
    private final FormatterWidth width;
    private final Multimap<String, String> indexInfo = null;

    public EnvironmentImpl(FormatterParams fparams, IsoLanguagesMapper mapper) {
        this.jdomMetadata = fparams.metadata;
        this.width = fparams.width;
        this.lang3 = fparams.context.getLanguage();
        this.lang2 = mapper.iso639_2_to_iso639_1(this.lang3, "en");
        this.formatType = fparams.formatType;
        this.resourceUrl = fparams.getResourceUrl();
        this.locUrl = fparams.getLocUrl();
        this.metadataInfo = fparams.metadataInfo;
        for (Map.Entry entry : fparams.webRequest.getParameterMap().entrySet()) {
            for (String value : (String[])entry.getValue()) {
                this.params.put(entry.getKey(), (Object)new ParamValue(value));
            }
        }
        this.webRequest = fparams.webRequest;
        this.serviceContext = fparams.context;
    }

    @Override
    public Multimap<String, ParamValue> params() {
        return this.params;
    }

    @Override
    public ParamValue param(String paramName) {
        Collection paramValues = this.params.get((Object)paramName);
        if (paramValues.isEmpty()) {
            return new ParamValue(""){

                @Override
                public String toString() {
                    return "Null Value";
                }

                @Override
                public boolean toBool() {
                    return false;
                }

                @Override
                public int toInt() {
                    return -1;
                }

                @Override
                public Double toDouble() {
                    return -1.0;
                }
            };
        }
        return (ParamValue)paramValues.iterator().next();
    }

    @Override
    public Collection<ParamValue> paramValues(String paramName) {
        return this.params.get((Object)paramName);
    }

    @Override
    public String getLang3() {
        return this.lang3;
    }

    @Override
    public String getLang2() {
        return this.lang2;
    }

    @Override
    public int getMetadataId() {
        return this.metadataInfo.getId();
    }

    @Override
    public String getMetadataUUID() {
        return this.metadataInfo.getUuid();
    }

    @Override
    public String getResourceUrl() {
        return this.resourceUrl;
    }

    @Override
    public String getLocalizedUrl() {
        return this.locUrl;
    }

    @Override
    public Authentication getAuth() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null) {
            return context.getAuthentication();
        }
        return null;
    }

    @Override
    public FormatType getFormatType() {
        return this.formatType;
    }

    @Override
    public FormatterWidth getEmbeddingWidth() {
        return this.width;
    }

    @Override
    public Element getMetadataElement() {
        return this.jdomMetadata;
    }

    @Override
    public synchronized Map<String, Collection<String>> getIndexInfo() throws Exception {
        if (this.indexInfo == null) {
            EsSearchManager searchManager = this.getBean(EsSearchManager.class);
            throw new NotImplementedException("Not implemented in ES");
        }
        return Collections.unmodifiableMap(this.indexInfo.asMap());
    }

    @Override
    public ServiceContext getContext() {
        return this.serviceContext;
    }

    @Override
    public <T> T getBean(Class<T> clazz) {
        return (T)this.serviceContext.getBean(clazz);
    }

    @Override
    public <T> T getBean(String name, Class<T> clazz) {
        return (T)this.serviceContext.getBean(name, clazz);
    }

    @Override
    public MapConfig getMapConfiguration() {
        SettingManager settingManager = (SettingManager)this.serviceContext.getBean(SettingManager.class);
        String background = settingManager.getValue("region/getmap/background");
        String mapproj = settingManager.getValue("region/getmap/mapproj");
        Integer width = settingManager.getValueAsInt("region/getmap/width");
        Integer thumbnailWidth = settingManager.getValueAsInt("region/getmap/summaryWidth");
        return new MapConfig(background, mapproj, width, thumbnailWidth);
    }

    @Override
    public boolean canEdit() throws Exception {
        AccessManager bean = (AccessManager)this.serviceContext.getBean(AccessManager.class);
        return bean.isOwner(this.serviceContext, this.metadataInfo.getSourceInfo()) || bean.hasEditPermission(this.serviceContext, String.valueOf(this.metadataInfo.getId()));
    }

    @Override
    public Optional<String> getHeader(String name) {
        return Optional.fromNullable((Object)this.webRequest.getHeader(name));
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return Arrays.asList(this.webRequest.getHeaderValues(name));
    }
}

