/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.records.extent.MapRenderer;
import org.fao.geonet.api.records.formatters.ImageReplacedElementFactory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.BinaryFile;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PDF
implements Service {
    private static final String TMP_PDF_FILE = "Document";

    public Element exec(Element metadata, ServiceContext context) throws Exception {
        Element htmlDoc = metadata.getChild("html");
        XMLOutputter printer = new XMLOutputter();
        String htmlContent = printer.outputString(htmlDoc);
        XslUtil.setNoScript();
        File tempDir = (File)context.getServlet().getServletContext().getAttribute("javax.servlet.context.tempdir");
        Path tempFile = Files.createTempFile(tempDir.toPath(), TMP_PDF_FILE, ".pdf", new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);){
            ITextRenderer renderer = new ITextRenderer();
            String siteUrl = ((SettingManager)context.getBean(SettingManager.class)).getSiteURL(context);
            MapRenderer mapRenderer = new MapRenderer(context);
            renderer.getSharedContext().setReplacedElementFactory((ReplacedElementFactory)new ImageReplacedElementFactory(siteUrl, renderer.getSharedContext().getReplacedElementFactory(), mapRenderer));
            renderer.setDocumentFromString(htmlContent, siteUrl);
            renderer.layout();
            renderer.createPDF(os);
        }
        return BinaryFile.encode((int)200, (Path)tempFile.toAbsolutePath().normalize(), (boolean)true).getElement();
    }

    public void init(Path appPath, ServiceConfig params) throws Exception {
    }
}

