/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.api.es.EsHTTPProxy;
import org.fao.geonet.api.records.model.related.AssociatedRecord;
import org.fao.geonet.api.records.model.related.RelatedItemOrigin;
import org.fao.geonet.api.records.model.related.RelatedItemType;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.Source;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.schema.AssociatedResource;
import org.fao.geonet.kernel.schema.AssociatedResourcesSchemaPlugin;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.kernel.search.EsFilterBuilder;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.specification.MetadataValidationSpecs;
import org.fao.geonet.services.relations.Get;
import org.fao.geonet.utils.BinaryFile;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class MetadataUtils {
    public static final boolean forEditing = false;
    public static final boolean withValidationErrors = false;
    public static final boolean keepXlinkAttributes = false;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.search");

    public static Map<RelatedItemType, List<AssociatedRecord>> getAssociated(ServiceContext context, AbstractMetadata md, RelatedItemType[] types, int start, int size) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        SettingManager settingManager = (SettingManager)gc.getBean(SettingManager.class);
        EsSearchManager searchMan = (EsSearchManager)gc.getBean(EsSearchManager.class);
        Element xml = dm.getMetadata(context, md.getId() + "", false, false, false);
        SchemaPlugin instance = SchemaManager.getSchemaPlugin((String)md.getDataInfo().getSchemaId());
        AssociatedResourcesSchemaPlugin schemaPlugin = instance instanceof AssociatedResourcesSchemaPlugin ? (AssociatedResourcesSchemaPlugin)instance : null;
        HashMap queries = new HashMap();
        HashSet allSearchedUuids = new HashSet();
        Arrays.stream(types).forEach(type -> {
            if (type == RelatedItemType.associated || type == RelatedItemType.hasfeaturecats || type == RelatedItemType.services || type == RelatedItemType.hassources) {
                queries.put(type, new RelatedTypeDetails(String.format("+%s:\"%s\"", EsSearchManager.relatedIndexFields.get(type.value()), md.getUuid())));
            } else if (schemaPlugin != null && (type == RelatedItemType.siblings || type == RelatedItemType.parent || type == RelatedItemType.fcats || type == RelatedItemType.datasets || type == RelatedItemType.sources)) {
                Set listOfAssociatedResources = new HashSet();
                if (type == RelatedItemType.siblings) {
                    listOfAssociatedResources = schemaPlugin.getAssociatedResourcesUUIDs(xml);
                } else if (type == RelatedItemType.sources) {
                    listOfAssociatedResources = schemaPlugin.getAssociatedSources(xml);
                } else if (type == RelatedItemType.datasets) {
                    listOfAssociatedResources = schemaPlugin.getAssociatedDatasets(xml);
                } else if (type == RelatedItemType.parent) {
                    listOfAssociatedResources = schemaPlugin.getAssociatedParents(xml);
                } else if (type == RelatedItemType.fcats) {
                    listOfAssociatedResources = schemaPlugin.getAssociatedFeatureCatalogues(xml);
                }
                HashSet<String> remoteRecords = new HashSet<String>();
                if (type == RelatedItemType.parent || listOfAssociatedResources.size() > 0) {
                    Set<String> listOfUUIDs = listOfAssociatedResources.stream().map(AssociatedResource::getUuid).collect(Collectors.toSet());
                    HashMap<String, Map<String, String>> recordsProperties = new HashMap<String, Map<String, String>>();
                    for (AssociatedResource r : listOfAssociatedResources) {
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("associationType", r.getAssociationType());
                        properties.put("initiativeType", r.getInitiativeType());
                        properties.put("resourceTitle", r.getTitle());
                        properties.put("url", r.getUrl());
                        recordsProperties.put(r.getUuid(), properties);
                        boolean isRemote = r.getUrl() != null && !r.getUrl().startsWith(settingManager.getBaseURL());
                        if (!isRemote) continue;
                        remoteRecords.add(r.getUuid());
                    }
                    queries.put(type, new RelatedTypeDetails(String.format("uuid:(%s)%s", listOfUUIDs.stream().collect(Collectors.joining("\" OR \"", "\"", "\"")), type == RelatedItemType.parent ? " OR childUuid:\"" + md.getUuid() + "\"" : ""), listOfUUIDs, recordsProperties, remoteRecords));
                    allSearchedUuids.addAll(listOfUUIDs);
                }
            } else if (schemaPlugin != null && type == RelatedItemType.brothersAndSisters) {
                Set listOfUUIDs = schemaPlugin.getAssociatedParentUUIDs(xml);
                queries.put(type, new RelatedTypeDetails(String.format("+%s:(%s) -uuid:\"%s\"", EsSearchManager.relatedIndexFields.get(type.value()), listOfUUIDs.stream().collect(Collectors.joining("\" OR \"", "\"", "\"")), md.getUuid()), listOfUUIDs));
                allSearchedUuids.addAll(listOfUUIDs);
            } else if (schemaPlugin != null && type == RelatedItemType.children) {
                Set listOfAssociated = schemaPlugin.getAssociatedResourcesUUIDs(xml);
                Set<String> isComposedOfList = listOfAssociated.stream().filter(e -> "isComposedOf".equals(e.getAssociationType())).map(AssociatedResource::getUuid).collect(Collectors.toSet());
                queries.put(type, new RelatedTypeDetails(String.format("%s:\"%s\" OR uuid:(%s)", EsSearchManager.relatedIndexFields.get(type.value()), md.getUuid(), isComposedOfList.stream().collect(Collectors.joining("\" OR \"", "\"", "\""))), isComposedOfList));
                allSearchedUuids.addAll(isComposedOfList);
            }
        });
        HashMap<RelatedItemType, List<AssociatedRecord>> associated = new HashMap<RelatedItemType, List<AssociatedRecord>>();
        HashSet<String> allCatalogueUuids = new HashSet<String>();
        String privilegesFilter = EsFilterBuilder.buildPermissionsFilter((ServiceContext)context);
        ObjectMapper mapper = new ObjectMapper();
        for (RelatedItemType type2 : queries.keySet()) {
            RelatedTypeDetails relatedTypeDetails = (RelatedTypeDetails)queries.get((Object)type2);
            SearchResponse result = searchMan.query(relatedTypeDetails.getQuery(), privilegesFilter, EsSearchManager.FIELDLIST_RELATED, start, size);
            Set<String> expectedUuids = relatedTypeDetails.getExpectedRecords();
            Set<String> remoteRecords = relatedTypeDetails.getRemoteRecords();
            ArrayList<AssociatedRecord> records = new ArrayList<AssociatedRecord>();
            if (result.getHits().getTotalHits().value > 0L) {
                for (SearchHit e : Arrays.asList(result.getHits().getHits())) {
                    allCatalogueUuids.add(e.getId());
                    AssociatedRecord record = new AssociatedRecord();
                    record.setUuid(e.getId());
                    record.setProperties((Map)relatedTypeDetails.recordsProperties.get(e.getId()));
                    JsonNode source = mapper.readTree(e.getSourceAsString());
                    ObjectNode doc = mapper.createObjectNode();
                    doc.set("_source", source);
                    EsHTTPProxy.addUserInfo(doc, context);
                    Iterator fieldNames = doc.fieldNames();
                    while (fieldNames.hasNext()) {
                        String field = (String)fieldNames.next();
                        if ("_source".equals(field)) continue;
                        ((ObjectNode)source).set(field, doc.get(field));
                    }
                    record.setRecord(source);
                    record.setOrigin(RelatedItemOrigin.catalog.name());
                    records.add(record);
                    if (expectedUuids.contains(e.getId())) {
                        expectedUuids.remove(e.getId());
                    }
                    if (!remoteRecords.contains(e.getId())) continue;
                    remoteRecords.remove(e.getId());
                }
            }
            MetadataUtils.buildRemoteRecords(mapper, relatedTypeDetails, records);
            associated.put(type2, records);
        }
        MetadataUtils.assignPortalOrigin(start, size, searchMan, associated, allCatalogueUuids);
        return associated;
    }

    private static void buildRemoteRecords(ObjectMapper mapper, RelatedTypeDetails relatedTypeDetails, List<AssociatedRecord> records) throws JsonProcessingException {
        for (String uuid : relatedTypeDetails.getRemoteRecords()) {
            AssociatedRecord record = new AssociatedRecord();
            record.setUuid(uuid);
            record.setProperties((Map)relatedTypeDetails.recordsProperties.get(uuid));
            record.setRecord(mapper.readTree(MetadataUtils.buildRemoteRecord((Map)relatedTypeDetails.recordsProperties.get(uuid))));
            record.setOrigin(RelatedItemOrigin.remote.name());
            records.add(record);
        }
    }

    private static void assignPortalOrigin(int start, int size, EsSearchManager searchMan, Map<RelatedItemType, List<AssociatedRecord>> associated, Set<String> allCatalogueUuids) throws Exception {
        Source portal;
        SourceRepository sourceRepository = (SourceRepository)ApplicationContextHolder.get().getBean(SourceRepository.class);
        NodeInfo node = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
        if (node != null && !"srv".equals(node.getId()) && StringUtils.isNotEmpty((String)(portal = (Source)sourceRepository.findById((Object)node.getId()).get()).getFilter())) {
            String portalFilter = portal.getFilter();
            SearchResponse recordsInPortal = searchMan.query(String.format("+uuid:(%s)", allCatalogueUuids.stream().collect(Collectors.joining("\" OR \"", "\"", "\""))), portalFilter, EsSearchManager.FIELDLIST_UUID, start, size);
            HashSet<String> allPortalUuids = new HashSet<String>();
            if (recordsInPortal.getHits().getTotalHits().value > 0L) {
                for (SearchHit e : Arrays.asList(recordsInPortal.getHits().getHits())) {
                    allPortalUuids.add(e.getId());
                }
            }
            if (allPortalUuids.size() > 0) {
                associated.forEach((t, records) -> records.stream().filter(r -> allPortalUuids.contains(r.getUuid())).forEach(r -> r.setOrigin(RelatedItemOrigin.portal.name())));
            }
        }
    }

    private static String buildRemoteRecord(Map<String, String> props) {
        return props == null ? "{}" : String.format("{\"resourceTitleObject\": {\"default\": \"%s\"}}", props.get("resourceTitle"));
    }

    @Deprecated
    public static Element getRelated(ServiceContext context, int iId, String uuid, RelatedItemType[] type, int from_, int to_, boolean fast_) throws Exception {
        String origin;
        Element searchResult;
        String joinedUUIDs;
        Set listOfUUIDs;
        Source portal;
        String id = String.valueOf(iId);
        String from = "" + from_;
        String to = "" + to_;
        String fast = "" + fast_;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        EsSearchManager searchMan = (EsSearchManager)gc.getBean(EsSearchManager.class);
        Element relatedRecords = new Element("relations");
        String portalFilter = "";
        NodeInfo node = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
        SourceRepository sourceRepository = (SourceRepository)ApplicationContextHolder.get().getBean(SourceRepository.class);
        if (node != null && !"srv".equals(node.getId()) && (portal = sourceRepository.findOneByUuid(node.getId())) != null) {
            portalFilter = portal.getFilter();
        }
        if (type == null || type.length == 0) {
            type = (RelatedItemType[])RelatedItemType.class.getEnumConstants();
        }
        ArrayList<RelatedItemType> listOfTypes = new ArrayList<RelatedItemType>(Arrays.asList(type));
        Element md = dm.getMetadata(context, id, false, false, false);
        Map mdIndexFields = searchMan.getDocument(uuid);
        String schemaIdentifier = dm.getMetadataSchema(id);
        SchemaPlugin instance = SchemaManager.getSchemaPlugin((String)schemaIdentifier);
        AssociatedResourcesSchemaPlugin schemaPlugin = null;
        if (instance instanceof AssociatedResourcesSchemaPlugin) {
            schemaPlugin = (AssociatedResourcesSchemaPlugin)instance;
        }
        if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.children)) {
            relatedRecords.addContent((Content)MetadataUtils.calculateResults("\"" + uuid + "\"", "children", context, from, to, fast, null, null, portalFilter));
        }
        if (schemaPlugin != null && (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.parent))) {
            listOfUUIDs = schemaPlugin.getAssociatedParentUUIDs(md);
            if (listOfUUIDs.size() > 0) {
                joinedUUIDs = "\"" + Joiner.on((String)"\" or \"").join((Iterable)listOfUUIDs) + "\"";
                relatedRecords.addContent((Content)MetadataUtils.calculateResults(joinedUUIDs, "parent", context, from, to, fast, null, null, portalFilter));
            } else {
                relatedRecords.addContent((Content)new Element("parent"));
            }
            MetadataUtils.appendRemoteRecord("parent", mdIndexFields, relatedRecords.getChild("parent"));
        }
        if (schemaPlugin != null && listOfTypes.contains((Object)RelatedItemType.brothersAndSisters) && (listOfUUIDs = schemaPlugin.getAssociatedParentUUIDs(md)).size() > 0) {
            joinedUUIDs = "\"" + Joiner.on((String)"\" or \"").join((Iterable)listOfUUIDs) + "\"";
            relatedRecords.addContent((Content)MetadataUtils.calculateResults(joinedUUIDs, RelatedItemType.brothersAndSisters.value(), context, from, to, fast, uuid, null, portalFilter));
        }
        if (schemaPlugin != null && (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.siblings))) {
            Element container;
            Element response = new Element("response");
            Set listOfAssociatedResources = schemaPlugin.getAssociatedResourcesUUIDs(md);
            if (listOfAssociatedResources != null) {
                for (AssociatedResource resource : listOfAssociatedResources) {
                    searchResult = MetadataUtils.search("\"" + resource.getUuid() + "\"", RelatedItemType.siblings.value(), context, from, to, fast, null, false);
                    origin = MetadataUtils.hasResult(searchResult) ? RelatedItemOrigin.portal.name() : RelatedItemOrigin.catalog.name();
                    Element sibContent = MetadataUtils.getRecord(resource.getUuid(), context, dm);
                    if (sibContent == null) continue;
                    Element sibling = new Element("sibling");
                    sibling.setAttribute("origin", origin);
                    sibling.setAttribute("initiative", resource.getInitiativeType());
                    sibling.setAttribute("association", resource.getAssociationType());
                    response.addContent((Content)sibling.addContent((Content)sibContent));
                }
            }
            if ((container = relatedRecords.getChild("siblings")) == null) {
                container = new Element("siblings");
                relatedRecords.addContent((Content)container);
            }
            container.addContent((Content)response);
            MetadataUtils.appendRemoteRecord("siblings", mdIndexFields, relatedRecords.getChild("siblings"));
        }
        if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.associated)) {
            relatedRecords.addContent((Content)MetadataUtils.calculateResults("\"" + uuid + "\"", "associated", context, from, to, fast, null, null, portalFilter));
        }
        if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.services)) {
            relatedRecords.addContent((Content)MetadataUtils.calculateResults("\"" + uuid + "\"", "services", context, from, to, fast, null, null, portalFilter));
        }
        if (schemaPlugin != null && (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.datasets) || listOfTypes.contains((Object)RelatedItemType.fcats) || listOfTypes.contains((Object)RelatedItemType.sources))) {
            if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.datasets)) {
                listOfUUIDs = schemaPlugin.getAssociatedDatasetUUIDs(md);
                if (listOfUUIDs != null && listOfUUIDs.size() > 0) {
                    joinedUUIDs = "\"" + Joiner.on((String)"\" or \"").join((Iterable)listOfUUIDs) + "\"";
                    relatedRecords.addContent((Content)MetadataUtils.calculateResults(joinedUUIDs, "datasets", context, from, to, fast, null, null, portalFilter));
                } else {
                    relatedRecords.addContent((Content)new Element("datasets"));
                }
                MetadataUtils.appendRemoteRecord("datasets", mdIndexFields, relatedRecords.getChild("datasets"));
            }
            if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.sources)) {
                listOfUUIDs = schemaPlugin.getAssociatedSourceUUIDs(md);
                if (listOfUUIDs != null && listOfUUIDs.size() > 0) {
                    joinedUUIDs = "\"" + Joiner.on((String)"\" or \"").join((Iterable)listOfUUIDs) + "\"";
                    relatedRecords.addContent((Content)MetadataUtils.calculateResults(joinedUUIDs, "sources", context, from, to, fast, null, null, portalFilter));
                } else {
                    relatedRecords.addContent((Content)new Element("sources"));
                }
                MetadataUtils.appendRemoteRecord("sources", mdIndexFields, relatedRecords.getChild("sources"));
            }
            if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.fcats)) {
                listOfUUIDs = schemaPlugin.getAssociatedFeatureCatalogueUUIDs(md);
                Element fcat = new Element("fcats");
                if (listOfUUIDs != null && listOfUUIDs.size() > 0) {
                    for (String fcat_uuid : listOfUUIDs) {
                        searchResult = MetadataUtils.search("\"" + fcat_uuid + "\"", RelatedItemType.fcats.value(), context, from, to, fast, null, false);
                        origin = MetadataUtils.hasResult(searchResult) ? RelatedItemOrigin.portal.name() : RelatedItemOrigin.catalog.name();
                        Element metadata = new Element("metadata");
                        Element response = new Element("response");
                        Element current = MetadataUtils.getRecord(fcat_uuid, context, dm);
                        if (current != null) {
                            metadata.setAttribute("origin", origin);
                            metadata.addContent((Content)current);
                        } else {
                            LOGGER.error("Feature catalogue with UUID {} referenced in {} was not found.", (Object)fcat_uuid, (Object)uuid);
                        }
                        response.addContent((Content)metadata);
                        fcat.addContent((Content)response);
                    }
                }
                relatedRecords.addContent((Content)fcat);
                MetadataUtils.appendRemoteRecord("fcats", mdIndexFields, fcat);
            }
        }
        if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.hassources)) {
            relatedRecords.addContent((Content)MetadataUtils.calculateResults("\"" + uuid + "\"", "hassources", context, from, to, fast, null, null, portalFilter));
        }
        if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.related)) {
            relatedRecords.addContent((Content)new Element("related").addContent((Content)Get.getRelation(iId, "full", context)));
            relatedRecords.addContent((Content)MetadataUtils.calculateResults("\"" + uuid + "\"", "hasfeaturecats", context, from, to, fast, null, null, portalFilter));
        }
        if (md != null && (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.onlines) || listOfTypes.contains((Object)RelatedItemType.thumbnails))) {
            relatedRecords.addContent((Content)new Element("metadata").addContent((Content)md.clone()));
        }
        return relatedRecords;
    }

    private static Element search(String uuidQueryValue, String type, ServiceContext context, String from, String to, String fast, String exclude, boolean ignorePortalFilter) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        EsSearchManager searchMan = (EsSearchManager)applicationContext.getBean(EsSearchManager.class);
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)("Searching for: " + type));
        }
        int fromValue = Integer.parseInt(from);
        int toValue = Integer.parseInt(to);
        String excludeQuery = "";
        if (exclude != null) {
            excludeQuery = String.format(" -uuid:%s", exclude);
        }
        String portalFilter = null;
        if (!ignorePortalFilter) {
            Source portal;
            SourceRepository sourceRepository = (SourceRepository)ApplicationContextHolder.get().getBean(SourceRepository.class);
            NodeInfo node = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
            if (node != null && !"srv".equals(node.getId()) && StringUtils.isNotEmpty((String)(portal = (Source)sourceRepository.findById((Object)node.getId()).get()).getFilter())) {
                portalFilter = portal.getFilter();
            }
        }
        SearchResponse result = searchMan.query(String.format("+%s:(%s)%s", EsSearchManager.relatedIndexFields.get(type), uuidQueryValue, excludeQuery), ignorePortalFilter ? null : portalFilter, EsSearchManager.FIELDLIST_CORE, fromValue, toValue - fromValue);
        Element typeResponse = new Element(type.equals("brothersAndSisters") ? "siblings" : type);
        if (result.getHits().getTotalHits().value > 0L) {
            Element response = new Element("response");
            Arrays.asList(result.getHits().getHits()).forEach(e -> {
                Element record = new Element("metadata");
                Map source = e.getSourceAsMap();
                record.addContent((Content)new Element("id").setText((String)source.get("id")));
                record.addContent((Content)new Element("uuid").setText((String)source.get("uuid")));
                if (type.equals("brothersAndSisters")) {
                    record.setAttribute("association", "brothersAndSisters");
                }
                MetadataUtils.setFieldFromIndexDocument(record, source, "resourceTitle", "title");
                MetadataUtils.setFieldFromIndexDocument(record, source, "resourceAbstract", "abstract");
                MetadataUtils.setFieldFromIndexDocument(record, source, "operatesOn", "operatesOn");
                response.addContent((Content)record);
            });
            typeResponse.addContent((Content)response);
        }
        return typeResponse;
    }

    private static void setFieldFromIndexDocument(Element record, Map<String, Object> source, String fieldName, String elementName) {
        Object fields = source.get(fieldName + "Object");
        if (fields == null) {
            fields = source.get(fieldName);
        }
        if (fields instanceof ArrayList) {
            ((ArrayList)fields).forEach(field -> record.addContent((Content)new Element(elementName).setText((String)field)));
        } else if (fields instanceof Map) {
            record.addContent((Content)new Element(elementName).setText((String)((Map)fields).get("default")));
        } else if (fields instanceof String) {
            record.addContent((Content)new Element(elementName).setText((String)fields));
        }
    }

    public static Set<String> getUuidsToExport(String query) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        EsSearchManager searchMan = (EsSearchManager)applicationContext.getBean(EsSearchManager.class);
        HashSet<String> uuids = new HashSet<String>();
        HashSet<String> field = new HashSet<String>(1);
        field.add("uuid");
        int from = 0;
        SettingInfo si = (SettingInfo)applicationContext.getBean(SettingInfo.class);
        int size = Integer.parseInt(si.getSelectionMaxRecords());
        SearchResponse result = searchMan.query(query, null, from, size);
        if (result.getHits().getTotalHits().value > 0L) {
            SearchHit[] elements = result.getHits().getHits();
            Arrays.asList(elements).forEach(e -> uuids.add((String)e.getSourceAsMap().get("uuid")));
        }
        Log.info((String)"geonetwork.mef", (Object)("  Found " + uuids.size() + " record(s)."));
        return uuids;
    }

    private static Element getRecord(String uuid, ServiceContext context, DataManager dm) {
        Element content;
        block2: {
            content = null;
            try {
                String id = dm.getMetadataId(uuid);
                Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
                content = dm.getMetadata(context, id, false, false, false);
            }
            catch (Exception e) {
                if (!Log.isDebugEnabled((String)"geonetwork.search")) break block2;
                Log.debug((String)"geonetwork.search", (Object)("Metadata " + uuid + " record is not visible for user."));
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void backupRecord(AbstractMetadata metadata, ServiceContext context) {
        Path outFile;
        Log.trace((String)"geonetwork.datamanager", (Object)("Backing up record " + metadata.getId()));
        Path outDir = Lib.resource.getRemovedDir(metadata.getId());
        try {
            outFile = outDir.resolve(URLEncoder.encode(metadata.getUuid(), Constants.ENCODING) + ".zip");
        }
        catch (UnsupportedEncodingException e1) {
            outFile = outDir.resolve(String.format("backup-%s-%s.mef", new Date(), metadata.getUuid()));
        }
        Path file = null;
        try {
            file = MEFLib.doExport((ServiceContext)context, (String)metadata.getUuid(), (String)"full", (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)true);
            Files.createDirectories(outDir, new FileAttribute[0]);
            try (InputStream is = IO.newInputStream((Path)file);
                 OutputStream os = Files.newOutputStream(outFile, new OpenOption[0]);){
                BinaryFile.copy((InputStream)is, (OutputStream)os);
            }
            if (file != null) return;
        }
        catch (Exception e) {
            try {
                Log.error((String)"geonetwork", (Object)("Backup record. Error: " + e.getMessage()), (Throwable)e);
                if (file != null) return;
            }
            catch (Throwable throwable) {
                if (file != null) throw throwable;
                IO.deleteFile(file, (boolean)false, (String)"geonetwork.mef");
                throw throwable;
            }
            IO.deleteFile((Path)file, (boolean)false, (String)"geonetwork.mef");
            return;
        }
        IO.deleteFile((Path)file, (boolean)false, (String)"geonetwork.mef");
        return;
    }

    public static boolean retrieveMetadataValidationStatus(AbstractMetadata metadata, ServiceContext context) throws Exception {
        boolean hasValidation;
        MetadataValidationRepository metadataValidationRepository = (MetadataValidationRepository)context.getBean(MetadataValidationRepository.class);
        IMetadataValidator validator = (IMetadataValidator)context.getBean(IMetadataValidator.class);
        DataManager dataManager = (DataManager)context.getBean(DataManager.class);
        boolean bl = hasValidation = metadataValidationRepository.count(MetadataValidationSpecs.hasMetadataId((int)metadata.getId())) > 0L;
        if (!hasValidation) {
            validator.doValidate(metadata, context.getLanguage());
            dataManager.indexMetadata(metadata.getId() + "", true);
        }
        boolean isInvalid = metadataValidationRepository.count(MetadataValidationSpecs.isInvalidAndRequiredForMetadata((int)metadata.getId())) > 0L;
        return isInvalid;
    }

    private static boolean hasResult(Element searchResponse) {
        if (searchResponse.getChildren().size() > 0) {
            Element containerResults = (Element)searchResponse.getChildren().get(0);
            return containerResults.getChildren().size() > 0;
        }
        return false;
    }

    private static Element calculateResults(String uuidQueryValue, String type, ServiceContext context, String from, String to, String fast, String exclude, String extraDumpFields, String portalFilter) throws Exception {
        Element results;
        block7: {
            block6: {
                results = MetadataUtils.search(uuidQueryValue, type, context, from, to, fast, exclude, true);
                if (!StringUtils.isNotEmpty((String)portalFilter)) break block6;
                Element resultsForPortal = MetadataUtils.search(uuidQueryValue, type, context, from, to, fast, exclude, false);
                HashSet<String> portalResultsUuids = new HashSet<String>();
                if (resultsForPortal.getChild("response") != null) {
                    for (Element r : resultsForPortal.getChild("response").getChildren()) {
                        String uuidValue = r.getChildText("uuid");
                        portalResultsUuids.add(uuidValue);
                    }
                }
                if (results.getChild("response") == null) break block7;
                for (Element r : results.getChild("response").getChildren()) {
                    String origin = RelatedItemOrigin.catalog.name();
                    String uuidValue = r.getChildText("uuid");
                    if (portalResultsUuids.contains(uuidValue)) {
                        origin = RelatedItemOrigin.portal.name();
                    }
                    r.setAttribute("origin", origin);
                }
                break block7;
            }
            if (results.getChild("response") != null) {
                for (Element r : results.getChild("response").getChildren()) {
                    r.setAttribute("origin", RelatedItemOrigin.portal.name());
                }
            }
        }
        return results;
    }

    private static void appendRemoteRecord(String type, Map<String, Object> mdIndexFields, Element typeRoot) {
        Object values = mdIndexFields.get("recordLink");
        if (values != null && values instanceof ArrayList) {
            Element responseRoot = null;
            if (typeRoot.getChild("response") != null) {
                responseRoot = typeRoot.getChild("response");
            } else {
                responseRoot = new Element("response");
                typeRoot.addContent((Content)responseRoot);
            }
            Element finalResponseRoot = responseRoot;
            ((ArrayList)values).forEach(recordLink -> {
                HashMap linkProperties;
                if (recordLink instanceof HashMap && type.equals((linkProperties = (HashMap)recordLink).get("type")) && "remote".equals(linkProperties.get("origin"))) {
                    Element record = new Element("metadata");
                    record.setAttribute("origin", RelatedItemOrigin.remote.name());
                    if (type.equals(RelatedItemType.siblings.value())) {
                        if (linkProperties.get("associationType") != null) {
                            record.setAttribute("association", (String)linkProperties.get("associationType"));
                        }
                        if (linkProperties.get("initiativeType") != null) {
                            record.setAttribute("initiative", (String)linkProperties.get("initiativeType"));
                        }
                    }
                    record.addContent((Content)new Element("id").setText((String)linkProperties.get("to")));
                    record.addContent((Content)new Element("uuid").setText((String)linkProperties.get("to")));
                    record.addContent((Content)new Element("title").setText((String)linkProperties.get("title")));
                    record.addContent((Content)new Element("url").setText((String)linkProperties.get("url")));
                    finalResponseRoot.addContent((Content)record);
                }
            });
        }
    }

    public static class RelatedTypeDetails {
        private String query;
        private Set<String> expectedRecords = new HashSet<String>();
        private Set<String> remoteRecords = new HashSet<String>();
        private Map<String, Map<String, String>> recordsProperties = new HashMap<String, Map<String, String>>();

        public RelatedTypeDetails(String query) {
            this.query = query;
        }

        public RelatedTypeDetails(String query, Set<String> expectedRecords) {
            this.query = query;
            this.expectedRecords = expectedRecords;
        }

        public RelatedTypeDetails(String query, Set<String> expectedRecords, Map<String, Map<String, String>> recordsProperties) {
            this.query = query;
            this.expectedRecords = expectedRecords;
            this.recordsProperties = recordsProperties;
        }

        public RelatedTypeDetails(String query, Set<String> expectedRecords, Map<String, Map<String, String>> recordsProperties, Set<String> remoteRecords) {
            this.query = query;
            this.expectedRecords = expectedRecords;
            this.recordsProperties = recordsProperties;
            this.remoteRecords = remoteRecords;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public Set<String> getExpectedRecords() {
            return this.expectedRecords;
        }

        public void setExpectedRecords(Set<String> expectedRecords) {
            this.expectedRecords = expectedRecords;
        }

        public Map<String, Map<String, String>> getRecordsProperties() {
            return this.recordsProperties;
        }

        public void setRecordsProperties(Map<String, Map<String, String>> recordsProperties) {
            this.recordsProperties = recordsProperties;
        }

        public Set<String> getRemoteRecords() {
            return this.remoteRecords;
        }
    }
}

