/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.SumVisitor;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;

public class CountVisitor
implements FeatureCalc {
    Integer count = null;

    public void init(SimpleFeatureCollection collection) {
    }

    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        if (this.count == null) {
            this.count = 0;
        }
        Integer n = this.count;
        Integer n2 = this.count = Integer.valueOf(this.count + 1);
    }

    public int getCount() {
        if (this.count == null) {
            return 0;
        }
        return this.count;
    }

    public void setValue(int count) {
        this.count = count;
    }

    public void reset() {
        this.count = null;
    }

    @Override
    public CalcResult getResult() {
        if (this.count == null) {
            return CalcResult.NULL_RESULT;
        }
        return new CountResult(this.count);
    }

    public static class CountResult
    extends AbstractCalcResult {
        private int count;

        public CountResult(int newcount) {
            this.count = newcount;
        }

        @Override
        public Object getValue() {
            return this.count;
        }

        @Override
        public boolean isCompatible(CalcResult targetResults) {
            if (targetResults == CalcResult.NULL_RESULT) {
                return true;
            }
            if (targetResults instanceof CountResult) {
                return true;
            }
            return targetResults instanceof SumVisitor.SumResult;
        }

        @Override
        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd == CalcResult.NULL_RESULT) {
                return this;
            }
            if (resultsToAdd instanceof CountResult) {
                int toAdd = resultsToAdd.toInt();
                return new CountResult(this.count + toAdd);
            }
            if (resultsToAdd instanceof SumVisitor.SumResult) {
                return resultsToAdd.merge(this);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

