/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.base14.Symbol;
import org.apache.fop.fonts.base14.ZapfDingbats;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFXObject;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;

public class PDFResources
extends PDFDictionary {
    protected Map<String, PDFDictionary> fonts = new LinkedHashMap<String, PDFDictionary>();
    protected Set<PDFXObject> xObjects = new LinkedHashSet<PDFXObject>();
    protected Map<LazyName, PDFColorSpace> colorSpaces = new LinkedHashMap<LazyName, PDFColorSpace>();
    protected Map<String, PDFICCBasedColorSpace> iccColorSpaces = new LinkedHashMap<String, PDFICCBasedColorSpace>();
    private PDFResources parent;
    private PDFDictionary fontsObj;
    private Map<String, PDFDictionary> fontsObjDict = new LinkedHashMap<String, PDFDictionary>();
    protected Map<String, PDFReference> properties = new LinkedHashMap<String, PDFReference>();
    protected Set<PDFResourceContext> contexts = new LinkedHashSet<PDFResourceContext>();

    public PDFResources(PDFDocument doc) {
        this.setObjectNumber(doc);
    }

    public void addContext(PDFResourceContext c) {
        this.contexts.add(c);
    }

    public void setParentResources(PDFResources p) {
        this.parent = p;
    }

    public PDFResources getParentResources() {
        return this.parent;
    }

    public void addFont(PDFFont font) {
        this.addFont(font.getName(), font);
    }

    public void addFont(String name, PDFDictionary font) {
        if (this.fontsObj != null) {
            this.fontsObj.put(name, font);
            this.fontsObjDict.put(name, font);
        } else {
            this.fonts.put(name, font);
        }
    }

    public void createFontsAsObj() {
        this.fontsObj = new PDFDictionary();
        this.getDocument().registerTrailerObject(this.fontsObj);
        this.put("Font", this.fontsObj);
    }

    public void addFonts(PDFDocument doc, FontInfo fontInfo) {
        Map<String, Typeface> usedFonts = fontInfo.getUsedFonts();
        for (Map.Entry<String, Typeface> e : usedFonts.entrySet()) {
            String f = e.getKey();
            Typeface font = e.getValue();
            if (!font.hadMappingOperations()) continue;
            FontDescriptor desc = null;
            if (font instanceof FontDescriptor) {
                desc = (FontDescriptor)((Object)font);
            }
            String encoding = font.getEncodingName();
            if (font instanceof Symbol || font instanceof ZapfDingbats) {
                encoding = null;
            }
            this.addFont(doc.getFactory().makeFont(f, font.getEmbedFontName(), encoding, font, desc));
        }
    }

    public void addXObject(PDFXObject xObject) {
        this.xObjects.add(xObject);
    }

    public void addColorSpace(PDFColorSpace colorSpace) {
        this.colorSpaces.put(new LazyName(colorSpace), colorSpace);
        if (colorSpace instanceof PDFICCBasedColorSpace) {
            PDFICCBasedColorSpace icc = (PDFICCBasedColorSpace)colorSpace;
            String desc = ColorProfileUtil.getICCProfileDescription((ICC_Profile)icc.getICCStream().getICCProfile());
            this.iccColorSpaces.put(desc, icc);
        }
    }

    public PDFICCBasedColorSpace getICCColorSpaceByProfileName(String desc) {
        PDFICCBasedColorSpace cs = this.iccColorSpaces.get(desc);
        return cs;
    }

    public PDFColorSpace getColorSpace(PDFName name) {
        for (Map.Entry<LazyName, PDFColorSpace> x : this.colorSpaces.entrySet()) {
            if (!x.getKey().getName().equals(name)) continue;
            return x.getValue();
        }
        return null;
    }

    public void addProperty(String name, PDFReference property) {
        this.properties.put(name, property);
    }

    public PDFReference getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public int output(OutputStream stream) throws IOException {
        this.populateDictionary();
        return super.output(stream);
    }

    private void populateDictionary() {
        PDFDictionary dict;
        if (this.parent != null && this.parent.fontsObj != null) {
            this.put("Font", this.parent.fontsObj);
        }
        if (!this.fonts.isEmpty() || this.parent != null && !this.parent.fonts.isEmpty()) {
            PDFDictionary dict3 = new PDFDictionary(this);
            for (Map.Entry<String, PDFDictionary> entry : this.fonts.entrySet()) {
                dict3.put(entry.getKey(), entry.getValue());
            }
            if (this.parent != null) {
                for (Map.Entry<String, PDFDictionary> entry : this.parent.fonts.entrySet()) {
                    dict3.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, PDFDictionary> entry : this.parent.fontsObjDict.entrySet()) {
                    dict3.put(entry.getKey(), entry.getValue());
                }
            }
            this.put("Font", dict3);
        }
        LinkedHashSet<PDFPattern> patterns = new LinkedHashSet<PDFPattern>();
        LinkedHashSet<PDFShading> shadings = new LinkedHashSet<PDFShading>();
        LinkedHashSet<PDFGState> gstates = new LinkedHashSet<PDFGState>();
        for (PDFResourceContext c : this.contexts) {
            this.xObjects.addAll(c.getXObjects());
            patterns.addAll(c.getPatterns());
            shadings.addAll(c.getShadings());
            gstates.addAll(c.getGStates());
        }
        if (this.parent != null) {
            this.xObjects.addAll(this.parent.xObjects);
            for (PDFResourceContext c : this.parent.contexts) {
                patterns.addAll(c.getPatterns());
                shadings.addAll(c.getShadings());
                gstates.addAll(c.getGStates());
            }
        }
        if (!shadings.isEmpty()) {
            PDFDictionary dict2 = (PDFDictionary)this.get("Shading");
            if (dict2 == null) {
                dict2 = new PDFDictionary(this);
            }
            for (PDFShading shading : shadings) {
                dict2.put(shading.getName(), shading);
            }
            this.put("Shading", dict2);
        }
        if (!patterns.isEmpty()) {
            PDFDictionary dict2 = (PDFDictionary)this.get("Pattern");
            if (dict2 == null) {
                dict2 = new PDFDictionary(this);
            }
            for (PDFPattern pattern : patterns) {
                dict2.put(pattern.getName(), pattern);
            }
            this.put("Pattern", dict2);
        }
        PDFArray procset = new PDFArray(this);
        procset.add(new PDFName("PDF"));
        procset.add(new PDFName("ImageB"));
        procset.add(new PDFName("ImageC"));
        procset.add(new PDFName("Text"));
        this.put("ProcSet", procset);
        if (!this.xObjects.isEmpty()) {
            dict = (PDFDictionary)this.get("XObject");
            if (dict == null) {
                dict = new PDFDictionary(this);
            }
            for (PDFXObject pDFXObject : this.xObjects) {
                dict.put(pDFXObject.getName().toString(), pDFXObject);
            }
            this.put("XObject", dict);
        }
        if (!gstates.isEmpty()) {
            dict = (PDFDictionary)this.get("ExtGState");
            if (dict == null) {
                dict = new PDFDictionary(this);
            }
            for (PDFGState pDFGState : gstates) {
                dict.put(pDFGState.getName(), pDFGState);
            }
            this.put("ExtGState", dict);
        }
        if (!this.colorSpaces.isEmpty() || this.parent != null && !this.parent.colorSpaces.isEmpty()) {
            dict = (PDFDictionary)this.get("ColorSpace");
            if (dict == null) {
                dict = new PDFDictionary(this);
            }
            if (this.parent != null) {
                for (PDFColorSpace pDFColorSpace : this.parent.colorSpaces.values()) {
                    dict.put(pDFColorSpace.getName(), pDFColorSpace);
                }
            }
            for (PDFColorSpace pDFColorSpace : this.colorSpaces.values()) {
                dict.put(pDFColorSpace.getName(), pDFColorSpace);
            }
            this.put("ColorSpace", dict);
        }
        if (!this.properties.isEmpty()) {
            dict = new PDFDictionary(this);
            for (Map.Entry entry : this.properties.entrySet()) {
                dict.put((String)entry.getKey(), entry.getValue());
            }
            this.put("Properties", dict);
        }
    }

    @Override
    public void getChildren(Set<PDFObject> children) {
        this.getChildren(children, false);
    }

    private void getChildren(Set<PDFObject> children, boolean isParent) {
        super.getChildren(children);
        for (PDFDictionary f : this.fonts.values()) {
            children.add(f);
            f.getChildren(children);
        }
        for (PDFResourceContext c : this.contexts) {
            for (PDFXObject pDFXObject : c.getXObjects()) {
                children.add(pDFXObject);
                pDFXObject.getChildren(children);
            }
            for (PDFPattern pDFPattern : c.getPatterns()) {
                children.add(pDFPattern);
                pDFPattern.getChildren(children);
            }
            for (PDFShading pDFShading : c.getShadings()) {
                children.add(pDFShading);
                pDFShading.getChildren(children);
            }
            for (PDFGState pDFGState : c.getGStates()) {
                children.add(pDFGState);
                pDFGState.getChildren(children);
            }
        }
        if (!isParent) {
            for (PDFColorSpace x : this.colorSpaces.values()) {
                children.add((PDFObject)((Object)x));
                ((PDFObject)((Object)x)).getChildren(children);
            }
        }
        if (this.parent != null) {
            this.parent.getChildren(children, true);
        }
    }

    static class LazyName {
        private PDFColorSpace colorSpace;

        public LazyName(PDFColorSpace colorSpace) {
            this.colorSpace = colorSpace;
        }

        public PDFName getName() {
            return new PDFName(this.colorSpace.getName());
        }
    }
}

