/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedVariable;

public class SynchronizedChar
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected char value_;

    public SynchronizedChar(char initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedChar(char initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    public char add(char amount) {
        Object object = this.lock_;
        synchronized (object) {
            char c = this.value_ = (char)(this.value_ + amount);
            Object var4_4 = null;
            return c;
        }
    }

    public boolean commit(char assumedValue, char newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success;
            boolean bl = success = assumedValue == this.value_;
            if (success) {
                this.value_ = newValue;
            }
            boolean bl2 = success;
            Object var5_6 = null;
            return bl2;
        }
    }

    public int compareTo(char other) {
        char val = this.get();
        return val < other ? -1 : (val == other ? 0 : 1);
    }

    public int compareTo(SynchronizedChar other) {
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        return this.compareTo((SynchronizedChar)other);
    }

    public char divide(char factor) {
        Object object = this.lock_;
        synchronized (object) {
            char c = this.value_ = (char)(this.value_ / factor);
            Object var4_4 = null;
            return c;
        }
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SynchronizedChar) {
            return this.get() == ((SynchronizedChar)other).get();
        }
        return false;
    }

    public final char get() {
        Object object = this.lock_;
        synchronized (object) {
            char c = this.value_;
            Object var3_3 = null;
            return c;
        }
    }

    public int hashCode() {
        return this.get();
    }

    public synchronized char multiply(char factor) {
        Object object = this.lock_;
        synchronized (object) {
            char c = this.value_ = (char)(this.value_ * factor);
            Object var4_4 = null;
            return c;
        }
    }

    public char set(char newValue) {
        Object object = this.lock_;
        synchronized (object) {
            char old = this.value_;
            this.value_ = newValue;
            char c = old;
            Object var4_5 = null;
            return c;
        }
    }

    public char subtract(char amount) {
        Object object = this.lock_;
        synchronized (object) {
            char c = this.value_ = (char)(this.value_ - amount);
            Object var4_4 = null;
            return c;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char swap(SynchronizedChar other) {
        if (other == this) {
            return this.get();
        }
        SynchronizedChar fst = this;
        SynchronizedChar snd = other;
        if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
            fst = other;
            snd = this;
        }
        Object object = fst.lock_;
        synchronized (object) {
            Object object2 = snd.lock_;
            synchronized (object2) {
                fst.set(snd.set(fst.get()));
                return this.get();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

