/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ucar.nc2.util.Misc;

public abstract class GridDefRecord {
    public static final boolean debug = false;
    public static final int UNDEFINED = -9999;
    public static final String GDS_KEY = "GDSkey";
    public static final String WIND_FLAG = "Winds";
    public static final String NX = "Nx";
    public static final String NY = "Ny";
    public static final String DX = "Dx";
    public static final String DY = "Dy";
    public static final String RESOLUTION = "ResCompFlag";
    public static final String VECTOR_COMPONENT_FLAG = "VectorComponentFlag";
    public static final String LATIN = "Latin";
    public static final String LATIN1 = "Latin1";
    public static final String LATIN2 = "Latin2";
    public static final String LA1 = "La1";
    public static final String LO1 = "Lo1";
    public static final String LA2 = "La2";
    public static final String LO2 = "Lo2";
    public static final String LAD = "LaD";
    public static final String LOV = "LoV";
    public static final String LAP = "Lap";
    public static final String LOP = "Lop";
    public static final String PLAT = "pLat";
    public static final String PLON = "pLon";
    public static final String SPLAT = "SpLat";
    public static final String SPLON = "SpLon";
    public static final String ROTATIONANGLE = "RotationAngle";
    public static final String STRETCHINGFACTOR = "StretchingFactor";
    public static final String ANGLE = "Angle";
    public static final String BASICANGLE = "BasicAngle";
    public static final String XP = "Xp";
    public static final String YP = "Yp";
    public static final String XO = "Xo";
    public static final String YO = "Yo";
    public static final String NP = "Np";
    public static final String NR = "Nr";
    public static final String J = "J";
    public static final String K = "K";
    public static final String M = "M";
    public static final String NUMBERPARALLELS = "NumberParallels";
    public static final String METHODNORM = "MethodNorm";
    public static final String MODEORDER = "ModeOrder";
    public static final String PROJ = "ProjFlag";
    public static final String NPPROJ = "NpProj";
    public static final String GRID_TYPE = "grid_type";
    public static final String GRID_NAME = "grid_name";
    public static final String GRID_SHAPE_CODE = "grid_shape_code";
    public static final String GRID_SHAPE = "grid_shape";
    public static final String RADIUS_SPHERICAL_EARTH = "grid_radius_spherical_earth";
    public static final String MAJOR_AXIS_EARTH = "grid_major_axis_earth";
    public static final String MINOR_AXIS_EARTH = "grid_minor_axis_earth";
    public static final String QUASI = "Quasi";
    public static final String GRID_UNITS = "grid_units";
    public static final String SCANNING_MODE = "scanning_mode";
    private final Map<String, String> paramStr = new HashMap<String, String>();
    private final Map<String, Integer> paramInt = new HashMap<String, Integer>();
    private final Map<String, Double> paramDbl = new HashMap<String, Double>();
    private String paramsValues;

    public GridDefRecord() {
        this.paramsValues = "";
    }

    public GridDefRecord(String paramsValues) {
        this.paramsValues = paramsValues;
        String[] split = paramsValues.split("\\t");
        for (int i = 0; i < split.length; i += 2) {
            this.paramStr.put(split[i], split[i + 1]);
        }
    }

    public final void addParam(String key, String value) {
        this.paramStr.put(key.trim(), value);
        this.paramsValues = this.paramsValues + "\t" + key + "\t" + value;
    }

    public final void addParam(String key, int value) {
        this.paramInt.put(key, new Integer(value));
        this.paramStr.put(key, Integer.toString(value));
    }

    public final void addParam(String key, Integer value) {
        this.paramInt.put(key, value);
    }

    public final void addParam(String key, float value) {
        this.paramDbl.put(key, new Double(value));
        this.paramStr.put(key, Float.toString(value));
    }

    public final void addParam(String key, double value) {
        this.paramDbl.put(key, new Double(value));
        this.paramStr.put(key, Double.toString(value));
    }

    public final void addParam(String key, Double value) {
        this.paramDbl.put(key, value);
    }

    public final String getParam(String key) {
        String value = this.paramStr.get(key);
        if (value == null) {
            Double result = this.paramDbl.get(key);
            if (result != null) {
                value = result.toString();
            } else {
                Integer intResult = this.paramInt.get(key);
                if (intResult != null) {
                    value = result.toString();
                }
            }
            if (value != null) {
                this.paramStr.put(key, value);
            }
        }
        return value;
    }

    public final int getParamInt(String key) {
        return this.getInt(key);
    }

    public final int getInt(String key) {
        Integer result = this.paramInt.get(key);
        if (result != null) {
            return result;
        }
        String value = this.paramStr.get(key);
        if (value != null) {
            try {
                result = new Integer(value.trim());
            }
            catch (NumberFormatException e) {
                double dvalue = this.getDouble(key);
                if (!Double.isNaN(dvalue)) {
                    result = new Integer((int)dvalue);
                    this.paramInt.put(key, result);
                    return result;
                }
                e.printStackTrace();
                return -9999;
            }
            this.paramInt.put(key, result);
            return result;
        }
        return -9999;
    }

    public final double getParamDouble(String key) {
        return this.getDouble(key);
    }

    public final double getDouble(String key) {
        Double result = this.paramDbl.get(key);
        if (result != null) {
            return result;
        }
        String value = this.paramStr.get(key);
        if (value != null) {
            try {
                result = new Double(value.trim());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return Double.NaN;
            }
            this.paramDbl.put(key, result);
            return result;
        }
        return Double.NaN;
    }

    public String getParamsValues() {
        return this.paramsValues;
    }

    public abstract String getGroupName();

    public final Set<String> getKeys() {
        return this.paramStr.keySet();
    }

    public final double readDouble(String name) {
        return this.getParamDouble(name);
    }

    public static boolean compare(GridDefRecord local, GridDefRecord other) {
        Set<String> keys = local.getKeys();
        Set<String> okeys = other.getKeys();
        if (keys.size() != okeys.size()) {
            return false;
        }
        for (String key : keys) {
            double od;
            double d;
            if (key.equals(WIND_FLAG) || key.equals(RESOLUTION) || key.equals(VECTOR_COMPONENT_FLAG) || key.equals(GDS_KEY)) continue;
            String val = local.getParam(key);
            String oval = other.getParam(key);
            if (!(val.matches("^[0-9]+\\.[0-9]*") ? !Misc.closeEnough(d = local.getDouble(key), od = other.getDouble(key)) : (val.matches("^[0-9]+") ? !val.equals(oval) : !val.equals(oval)))) continue;
            return false;
        }
        return true;
    }
}

