/*
 * Decompiled with CFR 0.152.
 */
package lizard.tiff;

import lizard.tiff.T4Tables;
import lizard.util.Converter;

class T4Code {
    public static final int EOL = -1;
    public static final int INVALID = -2;
    public static final int EOF = -3;
    public static final int INCOMP = -4;
    public int bitLength;
    public int codeWord;
    public int runLength;

    public T4Code() {
        this.bitLength = 0;
        this.codeWord = 0;
        this.runLength = 0;
    }

    public T4Code(T4Code c) {
        if (c != null) {
            this.bitLength = c.bitLength;
            this.codeWord = c.codeWord;
            this.runLength = c.runLength;
        } else {
            this.bitLength = 0;
            this.codeWord = 0;
            this.runLength = 0;
        }
    }

    public T4Code(int l, int c, int r) {
        this.bitLength = l;
        this.codeWord = c;
        this.runLength = r;
    }

    public T4Code(int[] codeArray) {
        if (codeArray.length == 3) {
            this.bitLength = codeArray[0];
            this.codeWord = codeArray[1];
            this.runLength = codeArray[2];
        } else {
            this.bitLength = 0;
            this.codeWord = 0;
            this.runLength = 0;
        }
    }

    public T4Code(byte[] octet, boolean whiteRun) {
        this();
        T4Code c = this.getCode(octet, whiteRun);
        if (c != null) {
            this.bitLength = c.bitLength;
            this.codeWord = c.codeWord;
            this.runLength = c.runLength;
        }
    }

    public T4Code getCode(byte[] octet, boolean whiteRun) {
        int i;
        int[][] table;
        T4Code c = null;
        int len = 0;
        int bits = 0;
        boolean found = false;
        if (whiteRun) {
            table = T4Tables.WhiteCodes;
            i = octet[0] == 0 ? 92 : 0;
        } else {
            table = T4Tables.BlackCodes;
            i = octet[0] == 0 ? 15 : 0;
        }
        while (!found && i < table.length) {
            int[] ca = table[i];
            if (len != ca[0]) {
                len = ca[0];
                bits = Converter.getBits(octet, len);
            }
            if (bits == ca[1]) {
                c = new T4Code(ca);
                found = true;
            }
            ++i;
        }
        return c;
    }

    public String toString() {
        StringBuffer sz = new StringBuffer();
        sz.append("{");
        sz.append(this.bitLength);
        sz.append(",");
        sz.append(this.runLength);
        sz.append(",");
        sz.append(Converter.intToBinaryString(this.codeWord, this.bitLength));
        sz.append("}");
        return sz.toString();
    }
}

