/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.repository.BatchUpdateQuery;
import org.fao.geonet.repository.GeonetRepository;
import org.fao.geonet.repository.PathSpec;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.Updater;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;

public class GeonetRepositoryImpl<T extends GeonetEntity, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements GeonetRepository<T, ID> {
    private final Class<T> _entityClass;
    private final JpaEntityInformation<T, ?> _entityInformation;
    protected EntityManager _entityManager;

    public GeonetRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this._entityManager = entityManager;
        this._entityInformation = entityInformation;
        this._entityClass = this.getDomainClass();
    }

    public GeonetRepositoryImpl(Class<T> domainClass, EntityManager entityManager) {
        super(domainClass, entityManager);
        this._entityManager = entityManager;
        this._entityInformation = JpaEntityInformationSupport.getEntityInformation(domainClass, (EntityManager)entityManager);
        this._entityClass = domainClass;
    }

    protected static <T extends GeonetEntity> Element findAllAsXml(EntityManager entityManager, Class<T> entityClass, Specification<T> specification, Pageable pageable) {
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(entityClass);
        Root root = query.from(entityClass);
        if (specification != null) {
            Predicate predicate = specification.toPredicate(root, query, cb);
            query.where((Expression)predicate);
        }
        if (pageable != null && pageable.getSort() != null) {
            List<Order> orders = SortUtils.sortToJpaOrders(cb, pageable.getSort(), root);
            query.orderBy(orders);
        }
        Element rootEl = new Element(entityClass.getSimpleName().toLowerCase());
        TypedQuery typedQuery = entityManager.createQuery(query);
        if (pageable != null) {
            typedQuery.setFirstResult(Math.toIntExact(pageable.getOffset()));
            typedQuery.setMaxResults(pageable.getPageSize());
        }
        for (GeonetEntity t : typedQuery.getResultList()) {
            rootEl.addContent((Content)t.asXml());
        }
        return rootEl;
    }

    @Override
    public T update(ID id, Updater<T> updater) {
        GeonetEntity entity = (GeonetEntity)this._entityManager.find(this._entityClass, id);
        if (entity == null) {
            throw new EntityNotFoundException("No entity found with id: " + id);
        }
        updater.apply(entity);
        this._entityManager.persist((Object)entity);
        this._entityManager.flush();
        return (T)entity;
    }

    @Override
    public <V> BatchUpdateQuery<T> createBatchUpdateQuery(PathSpec<T, V> pathToUpdate, V newValue) {
        return new BatchUpdateQuery<T>(this._entityClass, this._entityManager, pathToUpdate, newValue);
    }

    @Override
    public <V> BatchUpdateQuery<T> createBatchUpdateQuery(PathSpec<T, V> pathToUpdate, V newValue, Specification<T> spec) {
        BatchUpdateQuery<T> updateQuery = new BatchUpdateQuery<T>(this._entityClass, this._entityManager, pathToUpdate, newValue);
        updateQuery.setSpecification(spec);
        return updateQuery;
    }

    @Override
    @Nonnull
    public Element findAllAsXml() {
        return this.findAllAsXml(null, (Pageable)null);
    }

    @Override
    @Nonnull
    public Element findAllAsXml(Specification<T> specification) {
        return this.findAllAsXml(specification, (Pageable)null);
    }

    @Override
    @Nonnull
    public Element findAllAsXml(@Nullable Pageable pageable) {
        return this.findAllAsXml(null, pageable);
    }

    @Override
    @Nonnull
    public Element findAllAsXml(@Nullable Specification<T> specification, @Nullable Pageable pageable) {
        return GeonetRepositoryImpl.findAllAsXml(this._entityManager, this._entityClass, specification, pageable);
    }

    @Override
    @Nonnull
    public Element findAllAsXml(Sort sort) {
        return this.findAllAsXml(null, sort);
    }

    @Override
    @Transactional
    public int deleteAll(@Nonnull Specification<T> specification) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaDelete criteriaDelete = cb.createCriteriaDelete(this._entityClass);
        Root from = criteriaDelete.from(this._entityClass);
        Predicate predicate = specification.toPredicate(from, null, cb);
        criteriaDelete.where((Expression)predicate);
        Query query = this._entityManager.createQuery(criteriaDelete);
        int deleted = query.executeUpdate();
        this._entityManager.clear();
        return deleted;
    }

    @Override
    @Nonnull
    public Element findAllAsXml(Specification<T> specification, Sort sort) {
        PageRequest request = PageRequest.of((int)0, (int)Integer.MAX_VALUE, (Sort)sort);
        return GeonetRepositoryImpl.findAllAsXml(this._entityManager, this._entityClass, specification, (Pageable)request);
    }
}

