/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.Serializable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.Selection;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserSavedSelectionId;
import org.fao.geonet.entitylistener.UserMetadataSelectionEntityListenerManager;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="UserSavedSelections")
@EntityListeners(value={UserMetadataSelectionEntityListenerManager.class})
public class UserSavedSelection
extends GeonetEntity
implements Serializable {
    private UserSavedSelectionId _id = new UserSavedSelectionId();
    private Selection _selection;
    private User _user;
    private String _metadataUuid;

    public UserSavedSelection() {
    }

    public UserSavedSelection(Selection s, User u, String _metadataUuid) {
        this.setId(s, u, _metadataUuid);
    }

    @EmbeddedId
    public UserSavedSelectionId getId() {
        return this._id;
    }

    public UserSavedSelection setId(UserSavedSelectionId id) {
        this._id = id;
        return this;
    }

    public UserSavedSelection setId(Selection s, User u, String uuid) {
        this._selection = s;
        this._user = u;
        this._metadataUuid = uuid;
        this.setId(new UserSavedSelectionId(s, u, uuid));
        return this;
    }

    @MapsId(value="_userId")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="userId", referencedColumnName="id")
    public User getUser() {
        return this._user;
    }

    public void setUser(User user) {
        this._user = user;
        this.getId().setUserId(this._user.getId());
    }

    @MapsId(value="_selectionId")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="selectionId", referencedColumnName="id")
    public Selection getSelection() {
        return this._selection;
    }

    public void setSelection(Selection selection) {
        this._selection = selection;
        this.getId().setSelectionId(this._selection.getId());
    }

    @MapsId(value="_metadataUuid")
    @Column(name="metadataUuid", insertable=false, updatable=false)
    @JoinColumn(table="metadata", referencedColumnName="uuid", insertable=false, updatable=false)
    public String getMetadataUuid() {
        return this._metadataUuid;
    }

    public void setMetadataUuid(String metadataUuid) {
        this._metadataUuid = metadataUuid;
    }

    public String toString() {
        return "UserPersistentSelection: [" + this._id.toString() + "]";
    }
}

