/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.entitylistener.OperationEntityListenerManager;

@Entity
@Table(name="Operations")
@Cacheable
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={OperationEntityListenerManager.class})
@SequenceGenerator(name="operation_id_seq", initialValue=100, allocationSize=1)
public class Operation
extends Localized {
    static final String ID_SEQ_NAME = "operation_id_seq";
    private int _id;
    private String _name;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="operation_id_seq")
    @Column(name="id", nullable=false)
    public int getId() {
        return this._id;
    }

    public Operation setId(int id) {
        this._id = id;
        return this;
    }

    @Transient
    public boolean isReserved() {
        return this.getReservedOperation() != null;
    }

    @Column(name="name", nullable=false, length=32)
    @Nonnull
    public String getName() {
        return this._name;
    }

    public Operation setName(String name) {
        this._name = name;
        return this;
    }

    @Override
    @ElementCollection(fetch=FetchType.LAZY, targetClass=String.class)
    @CollectionTable(joinColumns={@JoinColumn(name="idDes")}, name="OperationsDes")
    @MapKeyColumn(name="langId", length=5)
    @Column(name="label", nullable=false)
    public Map<String, String> getLabelTranslations() {
        return super.getLabelTranslations();
    }

    @Transient
    @Nullable
    public ReservedOperation getReservedOperation() {
        return ReservedOperation.lookup(this._id);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operation other = (Operation)obj;
        return this._id == other._id;
    }

    public boolean is(ReservedOperation reservedOperation) {
        return reservedOperation.getId() == this.getId();
    }

    public String toString() {
        return "Operation [_id=" + this._id + ", _name=" + this._name + "]";
    }
}

