/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.Serializable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataType;

@Embeddable
@Access(value=AccessType.PROPERTY)
public class MetadataDataInfo
implements Serializable {
    private static final long serialVersionUID = 8049813754167665960L;
    public static final String CHANGE_DATE_COLUMN_NAME = "changedate";
    public static final String CREATE_DATE_COLUMN_NAME = "createdate";
    private String _title;
    private ISODate _changeDate;
    private ISODate _createDate;
    private String _schemaId;
    private char _template = (char)110;
    private String _root;
    private String _doctype;
    private String _extra;
    private Integer _displayOrder = 0;
    private int _rating = 0;
    private int _popularity = 0;

    public MetadataDataInfo() {
        long currentTime = System.currentTimeMillis();
        this._changeDate = new ISODate(currentTime);
        this._createDate = new ISODate(currentTime);
    }

    @Column
    public String getTitle() {
        return this._title;
    }

    public MetadataDataInfo setTitle(String title) {
        this._title = title;
        return this;
    }

    @Column
    public String getExtra() {
        return this._extra;
    }

    public MetadataDataInfo setExtra(String extra) {
        this._extra = extra;
        return this;
    }

    @Column(name="schemaId", length=32, nullable=false)
    public String getSchemaId() {
        return this._schemaId;
    }

    public MetadataDataInfo setSchemaId(String schemaId) {
        this._schemaId = schemaId;
        return this;
    }

    @Column(name="isTemplate", length=1, nullable=false)
    protected char getType_JPAWorkaround() {
        return this._template;
    }

    protected void setType_JPAWorkaround(char template) {
        this._template = template;
    }

    @Transient
    public MetadataType getType() {
        return MetadataType.lookup(this.getType_JPAWorkaround());
    }

    public MetadataDataInfo setType(MetadataType template) {
        this.setType_JPAWorkaround(template.code);
        return this;
    }

    @Column
    public String getRoot() {
        return this._root;
    }

    public MetadataDataInfo setRoot(String root) {
        this._root = root;
        return this;
    }

    @Column
    public String getDoctype() {
        return this._doctype;
    }

    public MetadataDataInfo setDoctype(String doctype) {
        this._doctype = doctype;
        return this;
    }

    @Column(name="displayorder")
    public Integer getDisplayOrder() {
        return this._displayOrder;
    }

    public MetadataDataInfo setDisplayOrder(Integer displayOrder) {
        this._displayOrder = displayOrder;
        return this;
    }

    @Column(nullable=false)
    public int getRating() {
        return this._rating;
    }

    public MetadataDataInfo setRating(int rating) {
        this._rating = rating;
        return this;
    }

    @Column(nullable=false)
    public int getPopularity() {
        return this._popularity;
    }

    public MetadataDataInfo setPopularity(int popularity) {
        this._popularity = popularity;
        return this;
    }

    @AttributeOverride(name="dateAndTimeUtc", column=@Column(name="changedate", nullable=false, length=30))
    public ISODate getChangeDate() {
        return this._changeDate;
    }

    public MetadataDataInfo setChangeDate(ISODate changeDate) {
        this._changeDate = changeDate;
        return this;
    }

    @AttributeOverride(name="dateAndTimeUtc", column=@Column(name="createdate", nullable=false, length=30))
    public ISODate getCreateDate() {
        return this._createDate;
    }

    public MetadataDataInfo setCreateDate(ISODate createDate) {
        this._createDate = createDate;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._changeDate == null ? 0 : this._changeDate.hashCode());
        result = 31 * result + (this._createDate == null ? 0 : this._createDate.hashCode());
        result = 31 * result + this._displayOrder;
        result = 31 * result + (this._doctype == null ? 0 : this._doctype.hashCode());
        result = 31 * result + this._popularity;
        result = 31 * result + this._rating;
        result = 31 * result + (this._root == null ? 0 : this._root.hashCode());
        result = 31 * result + (this._schemaId == null ? 0 : this._schemaId.hashCode());
        result = 31 * result + this._template;
        result = 31 * result + (this._title == null ? 0 : this._title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetadataDataInfo other = (MetadataDataInfo)obj;
        if (this._changeDate == null ? other._changeDate != null : !this._changeDate.equals(other._changeDate)) {
            return false;
        }
        if (this._createDate == null ? other._createDate != null : !this._createDate.equals(other._createDate)) {
            return false;
        }
        if (!this._displayOrder.equals(other._displayOrder)) {
            return false;
        }
        if (this._doctype == null ? other._doctype != null : !this._doctype.equals(other._doctype)) {
            return false;
        }
        if (this._popularity != other._popularity) {
            return false;
        }
        if (this._rating != other._rating) {
            return false;
        }
        if (this._root == null ? other._root != null : !this._root.equals(other._root)) {
            return false;
        }
        if (this._schemaId == null ? other._schemaId != null : !this._schemaId.equals(other._schemaId)) {
            return false;
        }
        if (this._template != other._template) {
            return false;
        }
        return !(this._title == null ? other._title != null : !this._title.equals(other._title));
    }

    public String toString() {
        return "MetadataDataInfo [" + (this._title != null ? "_title=" + this._title + ", " : "") + (this._changeDate != null ? "_changeDate=" + this._changeDate + ", " : "") + (this._createDate != null ? "_createDate=" + this._createDate + ", " : "") + (this._schemaId != null ? "_schemaId=" + this._schemaId + ", " : "") + "_template=" + this._template + ", " + (this._root != null ? "_root=" + this._root + ", " : "") + (this._doctype != null ? "_doctype=" + this._doctype + ", " : "") + (this._extra != null ? "_extra=" + this._extra + ", " : "") + (this._displayOrder != null ? "_displayOrder=" + this._displayOrder + ", " : "") + "_rating=" + this._rating + ", _popularity=" + this._popularity + "]";
    }

    public MetadataDataInfo clone() {
        MetadataDataInfo clon = new MetadataDataInfo();
        if (this.getChangeDate() != null) {
            clon.setChangeDate(this.getChangeDate().clone());
        }
        if (this.getCreateDate() != null) {
            clon.setCreateDate(this.getCreateDate().clone());
        }
        clon.setDisplayOrder(this.getDisplayOrder());
        clon.setDoctype(this.getDoctype());
        clon.setExtra(this.getExtra());
        clon.setPopularity(this.getPopularity());
        clon.setRating(this.getRating());
        clon.setRoot(this.getRoot());
        clon.setSchemaId(this.getSchemaId());
        clon.setType(this.getType());
        return clon;
    }
}

