/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.openrdf.sesame.sailimpl.rdbms.InferenceServices;
import org.openrdf.sesame.sailimpl.rdbms.RdfMTDependencyInferencer;
import org.openrdf.sesame.sailimpl.rdbms.RdfMTInferencer;
import org.openrdf.sesame.sailimpl.rdbms.RdfSchemaRepository;

public class RdbmsInferenceServices
implements InferenceServices {
    RdfSchemaRepository _sail = null;
    RdfMTDependencyInferencer _depInferencer = null;
    RdfMTInferencer _rdfMTInferencer = null;
    boolean _useDepInferencer;

    public RdbmsInferenceServices() {
        this._useDepInferencer = true;
    }

    public RdbmsInferenceServices(boolean useDepInferencer) {
        this._useDepInferencer = useDepInferencer;
    }

    public void setDependencyInferencer(boolean useDependencyInferencer) {
        this._useDepInferencer = useDependencyInferencer;
    }

    public void initialize(RdfSchemaRepository sail, Map configParams) {
        this._sail = sail;
    }

    public void initRdfSchema() {
        if (this._useDepInferencer) {
            this._depInferencer = new RdfMTDependencyInferencer(this._sail, this._sail._rdbms);
        }
        this._rdfMTInferencer = new RdfMTInferencer(this._sail, this._sail._rdbms);
        this._rdfMTInferencer.initialize();
    }

    public void doInferencing() {
        this._rdfMTInferencer.doInferencing();
    }

    public void removeExpiredStatements() throws SQLException {
        if (this._useDepInferencer) {
            this._makeExpiredStatementsInferred();
            this._determineGroundedStatements();
            Connection con = this._sail._rdbms.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery(" SELECT t.id FROM triples t LEFT JOIN groundedtriples g ON t.id = g.id WHERE g.id IS NULL");
            String[] idChunks = this._sail._chunkIdSet(rs, 3500);
            rs.close();
            st.close();
            con.setAutoCommit(false);
            st = con.createStatement();
            for (int i = 0; i < idChunks.length; ++i) {
                st.executeUpdate("DELETE FROM triples WHERE id IN " + idChunks[i]);
                st.executeUpdate("DELETE FROM depend WHERE id IN " + idChunks[i]);
                st.executeUpdate("DELETE FROM depend WHERE dep1 IN " + idChunks[i]);
                st.executeUpdate("DELETE FROM depend WHERE dep2 IN " + idChunks[i]);
                this._sail._processChunkFromRemoveExpiredStatements(idChunks[i]);
            }
            con.commit();
            st.close();
            con.close();
            this._sail._rdbms.clearTable("groundedtriples");
            this._sail._rdbms.clearTable("newgroundedtriples");
        } else {
            this._makeExpiredStatementsInferred();
            this._removeAllInferred();
            this._sail._rdbms.copyRows("triples", "newtriples");
            this._sail._rdbms.clearTable("triples");
            this._rdfMTInferencer.initialize();
        }
    }

    public void processNewStatements() throws SQLException {
        if (this._useDepInferencer) {
            this._depInferencer.processNewStatements();
        }
    }

    public void markAxioms() throws SQLException {
        if (this._useDepInferencer) {
            this._depInferencer.markAxioms();
        }
    }

    protected void _makeExpiredStatementsInferred() throws SQLException {
        Connection con = this._sail._rdbms.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("SELECT DISTINCT id FROM expiredtriples");
        String[] idChunks = this._sail._chunkIdSet(rs, 3500);
        rs.close();
        st.close();
        con.setAutoCommit(false);
        st = con.createStatement();
        for (int i = 0; i < idChunks.length; ++i) {
            st.executeUpdate("UPDATE triples SET explicit = " + this._sail._rdbms.FALSE + " WHERE id IN " + idChunks[i]);
        }
        con.commit();
        st.close();
        con.close();
    }

    private void _removeAllInferred() throws SQLException {
        this._sail._rdbms.executeUpdate("DELETE FROM triples WHERE explicit = " + this._sail._rdbms.FALSE);
    }

    protected void _determineGroundedStatements() throws SQLException {
        int count;
        this._sail._rdbms.executeUpdate("INSERT INTO groundedtriples VALUES(0)");
        this._sail._rdbms.executeUpdate("INSERT INTO groundedtriples SELECT id FROM triples WHERE explicit = " + this._sail._rdbms.TRUE);
        while ((count = this._sail._rdbms.executeUpdate("INSERT INTO newgroundedtriples SELECT DISTINCT d.id FROM depend d LEFT JOIN groundedtriples g1 ON d.dep1 = g1.id LEFT JOIN groundedtriples g2 ON d.dep2 = g2.id LEFT JOIN groundedtriples g3 ON d.id = g3.id WHERE g1.id IS NOT NULL AND g2.id IS NOT NULL AND g3.id IS NULL")) != 0) {
            this._sail._rdbms.copyRows("newgroundedtriples", "groundedtriples");
            this._sail._rdbms.clearTable("newgroundedtriples");
            this._sail._rdbms.optimizeTable("groundedtriples");
        }
    }

    public void createDependenciesTable() throws SQLException {
        this._sail._rdbms.executeUpdate("CREATE TABLE depend (id " + this._sail._rdbms.ID_INT + " NOT NULL, " + "dep1 " + this._sail._rdbms.ID_INT + " NOT NULL, " + "dep2 " + this._sail._rdbms.ID_INT + " NOT NULL)");
        this._sail._rdbms.createIndex("depend", new String[]{"id", "dep1", "dep2"}, false);
        this._sail._rdbms.createIndex("depend", new String[]{"dep1", "dep2"}, false);
    }

    public void afterInitialize() {
    }
}

