/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.util.Collection;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.QueryAnswer;
import org.openrdf.sesame.sail.query.QueryAnswerListener;
import org.openrdf.sesame.sail.query.SailQueryException;
import org.openrdf.sesame.sail.query.ValueExpr;

public class In
implements BooleanExpr {
    private ValueExpr _leftArg;
    private Query _rightArg;

    public In(ValueExpr leftArg, Query rightArg) {
        this._leftArg = leftArg;
        this._rightArg = rightArg;
    }

    public ValueExpr getLeftArg() {
        return this._leftArg;
    }

    public Query getRightArg() {
        return this._rightArg;
    }

    public void getVariables(Collection variables) {
        this._leftArg.getVariables(variables);
        this._rightArg.getVariables(variables);
    }

    public boolean isTrue(RdfSource rdfSource) throws SailQueryException {
        MembershipTester mst = new MembershipTester(this._leftArg.getValue());
        this._rightArg.evaluate(rdfSource, mst);
        return mst.isMember();
    }

    public String toString() {
        return this._leftArg + " IN (" + this._rightArg + ")";
    }

    private static class MembershipTester
    implements QueryAnswerListener {
        private Value _leftValue;
        private boolean _isMember = false;

        public MembershipTester(Value leftValue) {
            this._leftValue = leftValue;
        }

        public boolean queryAnswer(QueryAnswer qa) {
            Value rightValue = qa.getValue(0);
            this._isMember = this._leftValue == null && rightValue == null || this._leftValue != null && this._leftValue.equals(rightValue);
            return !this._isMember;
        }

        public void clear() {
        }

        public boolean isMember() {
            return this._isMember;
        }
    }
}

