/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.ParameterTableModel;
import org.openrdf.sesame.config.ui.XCellEditor;
import org.openrdf.sesame.config.ui.XTable;
import org.openrdf.sesame.config.ui.util.Util;

public class ParameterTable
extends XTable {
    String _id;
    String _sailClass;

    public ParameterTable(String id, SystemConfig config) {
        super(config);
        this._id = id;
        this.setXTableModel(new ParameterTableModel(id, config));
    }

    protected TableCellRenderer _createCellRenderer(int columnNo) {
        if (columnNo == 0 || columnNo == 1) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(this._model.getColumnAlignment(columnNo));
            return renderer;
        }
        return null;
    }

    protected TableCellEditor _createCellEditor(int columnNo) {
        XCellEditor editor = null;
        if (columnNo == 0) {
            editor = new KeyCellEditor(this);
        } else if (columnNo == 1) {
            editor = new XCellEditor(new JTextField(), (XTable)this);
        }
        return editor;
    }

    public void editingStopped(ChangeEvent e) {
        int row = this.getEditingRow();
        super.editingStopped(e);
        if (this._model.valueIsNew(row, 1)) {
            this.editCellAt(row, 1);
        }
    }

    public void addNewRow() {
        if (!this._config.hasASail(this._id)) {
            this._showWarningDialog("No sail defined.", "Add Parameter");
            return;
        }
        if (this._sailClass == null) {
            this._showWarningDialog("No sail selected.", "Add Parameter");
            return;
        }
        super.addNewRow();
    }

    public void removeRow() {
        if (!this._config.hasASail(this._id)) {
            this._showWarningDialog("No sail defined.", "Add Parameter");
            return;
        }
        if (this._sailClass == null) {
            this._showWarningDialog("No sail selected.", "Add Parameter");
            return;
        }
        String key = this.getIdentifierForSelectedRow();
        if (key == null) {
            this._showWarningDialog("No parameter selected.", "Remove Parameter");
            return;
        }
        if (Util.showYesNoDialog(this._getOwner(), "Are you sure you want to remove parameter '" + key + "'?", "Remove Parameter") == 0) {
            int row = this.getSelectedRow();
            this._config.removeParameter(this._id, this._sailClass, key);
            this.selectPreviousRowTo(row);
        }
    }

    public void setSailClass(String sailClass) {
        this._sailClass = sailClass;
        ParameterTableModel model = (ParameterTableModel)this._model;
        model.setSailClass(this._sailClass);
    }

    class KeyCellEditor
    extends XCellEditor {
        public KeyCellEditor(ParameterTable paramTable) {
            super(new JTextField(), (XTable)paramTable);
        }

        public boolean isValid() {
            String newKey = this.getCellEditorValue().toString();
            if (newKey.length() == 0) {
                ParameterTable.this._showWarningDialog("Key required.", "Edit Parameter");
                return false;
            }
            String oldKey = (String)this._value;
            if (!newKey.equals(oldKey) && ParameterTable.this._config.hasParameter(ParameterTable.this._id, ParameterTable.this._sailClass, newKey)) {
                ParameterTable.this._showWarningDialog("Parameter '" + newKey + "' already exists.", "Edit Parameter");
                return false;
            }
            return true;
        }
    }
}

