/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.chef.util.CollectionUtils;
import org.jclouds.javax.annotation.Nullable;

public class Group {
    private final String name;
    private final String groupname;
    private final String orgname;
    private final Set<String> actors;
    private final Set<String> clients;
    private final Set<String> groups;
    private final Set<String> users;

    public static Builder builder(String groupname) {
        return new Builder(groupname);
    }

    @ConstructorProperties(value={"name", "groupname", "orgname", "actors", "clients", "groups", "users"})
    public Group(String name, String groupname, String orgname, @Nullable Set<String> actors, @Nullable Set<String> clients, @Nullable Set<String> groups, @Nullable Set<String> users) {
        this.name = name;
        this.groupname = groupname;
        this.orgname = orgname;
        this.actors = CollectionUtils.copyOfOrEmpty(actors);
        this.clients = CollectionUtils.copyOfOrEmpty(clients);
        this.groups = CollectionUtils.copyOfOrEmpty(groups);
        this.users = CollectionUtils.copyOfOrEmpty(users);
    }

    public String getName() {
        return this.name;
    }

    public String getGroupname() {
        return this.groupname;
    }

    public String getOrgname() {
        return this.orgname;
    }

    public Set<String> getActors() {
        return this.actors;
    }

    public Set<String> getClients() {
        return this.clients;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupname == null ? 0 : this.groupname.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.orgname == null ? 0 : this.orgname.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        if (this.groupname == null ? other.groupname != null : !this.groupname.equals(other.groupname)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.orgname == null ? other.orgname != null : !this.orgname.equals(other.orgname));
    }

    public String toString() {
        return "Group [name=" + this.name + ", groupname=" + this.groupname + ", orgname=" + this.orgname + ", actors=" + this.actors + ", clients=" + this.clients + ", groups=" + this.groups + ", users=" + this.users + "]";
    }

    public static class Builder {
        private String name;
        private String groupname;
        private String orgname;
        private ImmutableSet.Builder<String> actors = ImmutableSet.builder();
        private ImmutableSet.Builder<String> clients = ImmutableSet.builder();
        private ImmutableSet.Builder<String> groups = ImmutableSet.builder();
        private ImmutableSet.Builder<String> users = ImmutableSet.builder();

        public Builder(String groupname) {
            this.groupname = groupname;
        }

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public Builder groupname(String groupname) {
            this.groupname = (String)Preconditions.checkNotNull((Object)groupname, (Object)"groupname");
            return this;
        }

        public Builder orgname(String orgname) {
            this.orgname = (String)Preconditions.checkNotNull((Object)orgname, (Object)"orgname");
            return this;
        }

        public Builder actor(String actor) {
            this.actors.add(Preconditions.checkNotNull((Object)actor, (Object)"actor"));
            return this;
        }

        public Builder actors(Iterable<String> actors) {
            this.actors.addAll((Iterable)Preconditions.checkNotNull(actors, (Object)"actors"));
            return this;
        }

        public Builder client(String client) {
            this.clients.add(Preconditions.checkNotNull((Object)client, (Object)"client"));
            return this;
        }

        public Builder clients(Iterable<String> clients) {
            this.clients.addAll((Iterable)Preconditions.checkNotNull(clients, (Object)"clients"));
            return this;
        }

        public Builder group(String group) {
            this.groups.add(Preconditions.checkNotNull((Object)group, (Object)"group"));
            return this;
        }

        public Builder groups(Iterable<String> groups) {
            this.groups.addAll((Iterable)Preconditions.checkNotNull(groups, (Object)"groups"));
            return this;
        }

        public Builder user(String user) {
            this.users.add(Preconditions.checkNotNull((Object)user, (Object)"user"));
            return this;
        }

        public Builder users(Iterable<String> users) {
            this.users.addAll((Iterable)Preconditions.checkNotNull(users, (Object)"users"));
            return this;
        }

        public Group build() {
            return new Group(this.name, (String)Preconditions.checkNotNull((Object)this.groupname, (Object)"groupname"), this.orgname, (Set<String>)this.actors.build(), (Set<String>)this.clients.build(), (Set<String>)this.groups.build(), (Set<String>)this.users.build());
        }
    }
}

