/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.PQFTranslationException;
import org.z3950.zing.cql.UnknownPositionException;
import org.z3950.zing.cql.UnknownQualifierException;
import org.z3950.zing.cql.UnknownRelationException;
import org.z3950.zing.cql.UnknownRelationModifierException;
import org.z3950.zing.cql.Utils;

public class CQLTermNode
extends CQLNode {
    private String qualifier;
    private CQLRelation relation;
    private String term;

    public CQLTermNode(String string, CQLRelation cQLRelation, String string2) {
        this.qualifier = string;
        this.relation = cQLRelation;
        this.term = string2;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public CQLRelation getRelation() {
        return this.relation;
    }

    public String getTerm() {
        return this.term;
    }

    private static boolean isResultSetQualifier(String string) {
        return string.equals("cql.resultSet") || string.equals("cql.resultSetId") || string.equals("cql.resultSetName");
    }

    public String getResultSetName() {
        if (CQLTermNode.isResultSetQualifier(this.qualifier)) {
            return this.term;
        }
        return null;
    }

    public String toXCQL(int n, Vector vector) {
        return CQLNode.indent(n) + "<searchClause>\n" + CQLNode.renderPrefixes(n + 1, vector) + CQLNode.indent(n + 1) + "<index>" + CQLNode.xq(this.qualifier) + "</index>\n" + this.relation.toXCQL(n + 1, new Vector()) + CQLNode.indent(n + 1) + "<term>" + CQLNode.xq(this.term) + "</term>\n" + CQLNode.indent(n) + "</searchClause>\n";
    }

    public String toCQL() {
        String string;
        String string2 = CQLTermNode.maybeQuote(this.qualifier);
        String string3 = string = CQLTermNode.maybeQuote(this.term);
        if (!this.qualifier.equalsIgnoreCase("cql.serverChoice")) {
            string3 = string2 + " " + this.relation.toCQL() + " " + string;
        }
        return string3;
    }

    private Vector getAttrs(Properties properties) throws PQFTranslationException {
        int n;
        Vector<String> vector = new Vector<String>();
        String string = properties.getProperty("always");
        if (string != null) {
            vector.add(string);
        }
        if ((string = properties.getProperty("qualifier." + this.qualifier)) == null) {
            throw new UnknownQualifierException(this.qualifier);
        }
        vector.add(string);
        String string2 = this.relation.getBase();
        if (string2.equals("=")) {
            string2 = "eq";
        } else if (string2.equals("<=")) {
            string2 = "le";
        } else if (string2.equals(">=")) {
            string2 = "ge";
        }
        string = properties.getProperty("relation." + string2);
        if (string == null) {
            throw new UnknownRelationException(string2);
        }
        vector.add(string);
        String[] stringArray = this.relation.getModifiers();
        int n2 = 0;
        while (n2 < stringArray.length) {
            string = properties.getProperty("relationModifier." + stringArray[n2]);
            if (string == null) {
                throw new UnknownRelationModifierException(stringArray[n2]);
            }
            vector.add(string);
            ++n2;
        }
        String string3 = "any";
        String string4 = this.term;
        if (string4.length() > 0 && string4.substring(0, 1).equals("^")) {
            string4 = string4.substring(1);
            string3 = "first";
        }
        if ((n = string4.length()) > 0 && string4.substring(n - 1, n).equals("^")) {
            string4 = string4.substring(0, n - 1);
            String string5 = string3 = string3.equals("first") ? "firstAndLast" : "last";
        }
        if ((string = properties.getProperty("position." + string3)) == null) {
            throw new UnknownPositionException(string3);
        }
        vector.add(string);
        string = properties.getProperty("structure." + string2);
        if (string == null) {
            string = properties.getProperty("structure.*");
        }
        vector.add(string);
        return vector;
    }

    public String toPQF(Properties properties) throws PQFTranslationException {
        int n;
        if (CQLTermNode.isResultSetQualifier(this.qualifier)) {
            return "@set " + CQLTermNode.maybeQuote(this.term);
        }
        Vector vector = this.getAttrs(properties);
        String string = "";
        int n2 = 0;
        while (n2 < vector.size()) {
            String string2 = (String)vector.get(n2);
            string = string + "@attr " + Utils.replaceString(string2, " ", " @attr ") + " ";
            ++n2;
        }
        String string3 = this.term;
        if (string3.length() > 0 && string3.substring(0, 1).equals("^")) {
            string3 = string3.substring(1);
        }
        if ((n = string3.length()) > 0 && string3.substring(n - 1, n).equals("^")) {
            string3 = string3.substring(0, n - 1);
        }
        return string + CQLTermNode.maybeQuote(string3);
    }

    static String maybeQuote(String string) {
        if (string.length() == 0 || string.indexOf(34) != -1 || string.indexOf(32) != -1 || string.indexOf(9) != -1 || string.indexOf(61) != -1 || string.indexOf(60) != -1 || string.indexOf(62) != -1 || string.indexOf(47) != -1 || string.indexOf(40) != -1 || string.indexOf(41) != -1) {
            string = '\"' + Utils.replaceString(string, "\"", "\\\"") + '\"';
        }
        return string;
    }

    public byte[] toType1BER(Properties properties) throws PQFTranslationException {
        Object object;
        int n;
        if (CQLTermNode.isResultSetQualifier(this.qualifier)) {
            byte[] byArray = new byte[this.term.length() + 100];
            int n2 = CQLNode.putTag(2, 0, 1, byArray, 0);
            byArray[n2++] = -128;
            n2 = CQLNode.putTag(2, 31, 0, byArray, n2);
            byte[] byArray2 = this.term.getBytes();
            n2 = CQLNode.putLen(byArray2.length, byArray, n2);
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
            byArray[n2++] = 0;
            byArray[n2++] = 0;
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, 0, byArray3, 0, n2);
            return byArray3;
        }
        String string = this.term;
        if (string.length() > 0 && string.substring(0, 1).equals("^")) {
            string = string.substring(1);
        }
        if ((n = string.length()) > 0 && string.substring(n - 1, n).equals("^")) {
            string = string.substring(0, n - 1);
        }
        String string2 = string;
        byte[] byArray = new byte[3 * string.length() + 100];
        int n3 = CQLNode.putTag(2, 0, 1, byArray, 0);
        byArray[n3++] = -128;
        n3 = CQLNode.putTag(2, 102, 1, byArray, n3);
        byArray[n3++] = -128;
        n3 = CQLNode.putTag(2, 44, 1, byArray, n3);
        byArray[n3++] = -128;
        Vector vector = this.getAttrs(properties);
        int n4 = 0;
        while (n4 < vector.size()) {
            String string3 = (String)vector.get(n4);
            object = new StringTokenizer(string3);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken();
                int n5 = string4.indexOf(61);
                n3 = CQLNode.putTag(0, 16, 1, byArray, n3);
                byArray[n3++] = -128;
                n3 = CQLNode.putTag(2, 120, 0, byArray, n3);
                int n6 = Integer.parseInt(string4.substring(0, n5));
                n3 = CQLNode.putLen(CQLNode.numLen(n6), byArray, n3);
                n3 = CQLNode.putNum(n6, byArray, n3);
                n3 = CQLNode.putTag(2, 121, 0, byArray, n3);
                int n7 = Integer.parseInt(string4.substring(n5 + 1));
                n3 = CQLNode.putLen(CQLNode.numLen(n7), byArray, n3);
                n3 = CQLNode.putNum(n7, byArray, n3);
                byArray[n3++] = 0;
                byArray[n3++] = 0;
            }
            ++n4;
        }
        byArray[n3++] = 0;
        byArray[n3++] = 0;
        n3 = CQLNode.putTag(2, 45, 0, byArray, n3);
        object = null;
        try {
            object = string2.getBytes("utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        n3 = CQLNode.putLen(((StringTokenizer)object).length, byArray, n3);
        System.arraycopy(object, 0, byArray, n3, ((Object)object).length);
        n3 += ((Object)object).length;
        byArray[n3++] = 0;
        byArray[n3++] = 0;
        byArray[n3++] = 0;
        byArray[n3++] = 0;
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray, 0, byArray4, 0, n3);
        return byArray4;
    }
}

