/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.feature;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.geotools.geojson.GeoJSONUtil;
import org.geotools.geojson.feature.AttributeIO;
import org.geotools.geojson.feature.DefaultAttributeIO;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class FeatureTypeAttributeIO
implements AttributeIO {
    HashMap<String, AttributeIO> ios = new HashMap();

    public FeatureTypeAttributeIO(SimpleFeatureType featureType) {
        for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
            AttributeIO io = null;
            io = Date.class.isAssignableFrom(ad.getType().getBinding()) ? new DateAttributeIO() : new DefaultAttributeIO();
            this.ios.put(ad.getLocalName(), io);
        }
    }

    @Override
    public String encode(String att, Object value) {
        return this.ios.get(att).encode(att, value);
    }

    @Override
    public Object parse(String att, String value) {
        return this.ios.get(att).parse(att, value);
    }

    static class DateAttributeIO
    implements AttributeIO {
        DateAttributeIO() {
        }

        @Override
        public String encode(String att, Object value) {
            return GeoJSONUtil.dateFormatter.format((Date)value);
        }

        @Override
        public Object parse(String att, String value) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                return sdf.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

