/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.license;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.common.ProtocolUtils;
import org.elasticsearch.client.license.LicensesStatus;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Tuple;

public final class PutLicenseResponse {
    private static final ConstructingObjectParser<PutLicenseResponse, Void> PARSER = new ConstructingObjectParser("put_license_response", true, (a, v) -> {
        boolean acknowledged = (Boolean)a[0];
        LicensesStatus licensesStatus = LicensesStatus.fromString((String)a[1]);
        Tuple acknowledgements = (Tuple)a[2];
        if (acknowledgements == null) {
            return new PutLicenseResponse(acknowledged, licensesStatus);
        }
        return new PutLicenseResponse(acknowledged, licensesStatus, (String)acknowledgements.v1(), (Map)acknowledgements.v2());
    });
    private boolean acknowledged;
    private LicensesStatus status;
    private Map<String, String[]> acknowledgeMessages;
    private String acknowledgeHeader;

    public PutLicenseResponse() {
    }

    public PutLicenseResponse(boolean acknowledged, LicensesStatus status) {
        this(acknowledged, status, null, Collections.emptyMap());
    }

    public PutLicenseResponse(boolean acknowledged, LicensesStatus status, String acknowledgeHeader, Map<String, String[]> acknowledgeMessages) {
        this.acknowledged = acknowledged;
        this.status = status;
        this.acknowledgeHeader = acknowledgeHeader;
        this.acknowledgeMessages = acknowledgeMessages;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public LicensesStatus status() {
        return this.status;
    }

    public Map<String, String[]> acknowledgeMessages() {
        return this.acknowledgeMessages;
    }

    public String acknowledgeHeader() {
        return this.acknowledgeHeader;
    }

    public static PutLicenseResponse fromXContent(XContentParser parser) throws IOException {
        return (PutLicenseResponse)PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutLicenseResponse that = (PutLicenseResponse)o;
        return this.status == that.status && ProtocolUtils.equals(this.acknowledgeMessages, that.acknowledgeMessages) && Objects.equals(this.acknowledgeHeader, that.acknowledgeHeader);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.status, ProtocolUtils.hashCode(this.acknowledgeMessages), this.acknowledgeHeader});
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("acknowledged", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("license_status", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, v) -> {
            XContentParser.Token token;
            HashMap<String, String[]> acknowledgeMessages = new HashMap<String, String[]>();
            String message = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (currentFieldName == null) {
                    throw new XContentParseException(parser.getTokenLocation(), "expected message header or acknowledgement");
                }
                if ("message".equals(currentFieldName)) {
                    if (token != XContentParser.Token.VALUE_STRING) {
                        throw new XContentParseException(parser.getTokenLocation(), "unexpected message header type");
                    }
                    message = parser.text();
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY) {
                    throw new XContentParseException(parser.getTokenLocation(), "unexpected acknowledgement type");
                }
                ArrayList<String> acknowledgeMessagesList = new ArrayList<String>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token != XContentParser.Token.VALUE_STRING) {
                        throw new XContentParseException(parser.getTokenLocation(), "unexpected acknowledgement text");
                    }
                    acknowledgeMessagesList.add(parser.text());
                }
                acknowledgeMessages.put(currentFieldName, acknowledgeMessagesList.toArray(new String[0]));
            }
            return new Tuple(message, acknowledgeMessages);
        }, new ParseField("acknowledge", new String[0]));
    }
}

