/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import org.dlib.gui.print.GraphicPrinterListener;
import org.dlib.gui.print.GraphicPrinterSource;
import org.dlib.gui.print.PageMargins;

public class GraphicPrinter
implements Printable {
    private int lastPage;
    private double scale = 1.0;
    private PrinterJob job;
    private PrintService service;
    private Vector vPages;
    private GraphicPrinterSource source;
    private GraphicPrinterListener listener;
    private PrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
    private static final double MM2PIXEL = 2.834645669291339;
    public static final String PAGE_A4 = "A4";
    public static final String PAGE_LETTER = "letter";
    public static final String PAGE_LEGAL = "legal";
    static /* synthetic */ Class class$javax$print$attribute$standard$Media;
    static /* synthetic */ Class class$javax$print$attribute$standard$MediaPrintableArea;

    public GraphicPrinter() {
        this.job = PrinterJob.getPrinterJob();
        this.job.setPrintable(this);
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        this.service = printServiceArray.length > 0 ? printServiceArray[0] : null;
        this.attr.add(MediaSizeName.ISO_A4);
        this.setMargins(new PageMargins(10.0f, 10.0f, 10.0f, 10.0f));
    }

    public boolean printerExists() {
        return this.service != null;
    }

    public void setPrinterSource(GraphicPrinterSource graphicPrinterSource) {
        this.source = graphicPrinterSource;
    }

    public void setPrinterListener(GraphicPrinterListener graphicPrinterListener) {
        this.listener = graphicPrinterListener;
    }

    public void setScaleFactor(double d) {
        this.scale = d;
    }

    public double getScaleFactor() {
        return this.scale;
    }

    public void setMargins(PageMargins pageMargins) {
        MediaSizeName mediaSizeName = (MediaSizeName)this.attr.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = GraphicPrinter.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        float f = mediaSize.getX(1000);
        float f2 = mediaSize.getY(1000);
        MediaPrintableArea mediaPrintableArea = new MediaPrintableArea(pageMargins.left, pageMargins.top, f - pageMargins.left - pageMargins.right, f2 - pageMargins.top - pageMargins.bottom, 1000);
        this.attr.add(mediaPrintableArea);
    }

    public PageMargins getMargins() {
        MediaSizeName mediaSizeName = (MediaSizeName)this.attr.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = GraphicPrinter.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)this.attr.get(class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = GraphicPrinter.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea);
        float f = mediaSize.getX(1000);
        float f2 = mediaSize.getY(1000);
        float f3 = mediaPrintableArea.getX(1000);
        float f4 = mediaPrintableArea.getY(1000);
        float f5 = f - mediaPrintableArea.getWidth(1000) - f3;
        float f6 = f2 - mediaPrintableArea.getHeight(1000) - f4;
        return new PageMargins(f3, f4, f5, f6);
    }

    public void setPageSize(String string) {
        MediaSizeName mediaSizeName = string.equals(PAGE_LETTER) ? MediaSizeName.NA_LETTER : (string.equals(PAGE_LEGAL) ? MediaSizeName.NA_LEGAL : MediaSizeName.ISO_A4);
        this.attr.add(mediaSizeName);
    }

    public String getPageSize() {
        MediaSizeName mediaSizeName = (MediaSizeName)this.attr.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = GraphicPrinter.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
        if (mediaSizeName == MediaSizeName.NA_LETTER) {
            return PAGE_LETTER;
        }
        if (mediaSizeName == MediaSizeName.NA_LEGAL) {
            return PAGE_LEGAL;
        }
        return PAGE_A4;
    }

    public boolean showDialog() {
        return this.job.printDialog(this.attr);
    }

    public void print() throws PrinterException {
        this.vPages = null;
        this.job.print(this.attr);
    }

    public List preview(int n) {
        PageFormat pageFormat = this.getPageFormat();
        double d = pageFormat.getWidth();
        double d2 = pageFormat.getHeight();
        double d3 = pageFormat.getImageableX();
        double d4 = pageFormat.getImageableY();
        double d5 = pageFormat.getImageableWidth();
        double d6 = pageFormat.getImageableHeight();
        this.prepare(pageFormat);
        int n2 = (int)((double)n * d2 / d);
        double d7 = (double)n / d;
        int n3 = (int)(d3 * d7);
        int n4 = (int)(d4 * d7);
        int n5 = (int)(d5 * d7);
        int n6 = (int)(d6 * d7);
        int n7 = n - n5 - n3;
        int n8 = n2 - n6 - n4;
        Vector<BufferedImage> vector = new Vector<BufferedImage>();
        for (int i = 0; i < this.vPages.size(); ++i) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n, n2);
            Point2D.Double double_ = (Point2D.Double)this.vPages.elementAt(i);
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.scale(d7, d7);
            graphics2D.translate(d3, d4);
            graphics2D.translate(-double_.x, -double_.y);
            graphics2D.scale(this.scale, this.scale);
            this.source.print(graphics2D);
            graphics2D.setTransform(affineTransform);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n3 - 1, n2);
            graphics2D.fillRect(0, 0, n, n4 - 1);
            graphics2D.fillRect(n - n7 + 1, 0, n7 - 1, n2);
            graphics2D.fillRect(0, n2 - n8 + 1, n, n8 - 1);
            graphics2D.dispose();
            vector.add(bufferedImage);
        }
        return vector;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.vPages == null) {
            this.lastPage = -1;
            this.prepare(pageFormat);
            if (this.listener != null) {
                this.listener.begin(this.vPages.size());
            }
        }
        if (n < this.vPages.size()) {
            if (this.lastPage != n && this.listener != null) {
                this.listener.printing(n + 1, this.vPages.size());
            }
            Point2D.Double double_ = (Point2D.Double)this.vPages.elementAt(n);
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            graphics2D.translate(-double_.x, -double_.y);
            graphics2D.scale(this.scale, this.scale);
            this.source.print(graphics2D);
            if (this.lastPage != n && this.listener != null) {
                this.listener.printed(n + 1, this.vPages.size());
            }
            this.lastPage = n;
            return 0;
        }
        if (this.listener != null) {
            this.listener.end();
        }
        return 1;
    }

    private void prepare(PageFormat pageFormat) {
        this.vPages = this.calcNumPages((double)this.source.getWidth() * this.scale, (double)this.source.getHeight() * this.scale, pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
    }

    private Vector calcNumPages(double d, double d2, double d3, double d4) {
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        for (double d5 = 0.0; d5 < d2; d5 += d4) {
            for (double d6 = 0.0; d6 < d; d6 += d3) {
                vector.addElement(new Point2D.Double(d6, d5));
            }
        }
        return vector;
    }

    private PageFormat getPageFormat() {
        MediaSizeName mediaSizeName = (MediaSizeName)this.attr.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = GraphicPrinter.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)this.attr.get(class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = GraphicPrinter.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea);
        double d = 2.834645669291339 * (double)mediaSize.getX(1000);
        double d2 = 2.834645669291339 * (double)mediaSize.getY(1000);
        double d3 = 2.834645669291339 * (double)mediaPrintableArea.getX(1000);
        double d4 = 2.834645669291339 * (double)mediaPrintableArea.getY(1000);
        double d5 = 2.834645669291339 * (double)mediaPrintableArea.getWidth(1000);
        double d6 = 2.834645669291339 * (double)mediaPrintableArea.getHeight(1000);
        Paper paper = new Paper();
        paper.setSize(d, d2);
        paper.setImageableArea(d3, d4, d5, d6);
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

