/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.processor.support.CssImportInspector;
import ro.isdc.wro.util.WroUtil;

public class CssUrlInspector {
    private static final Logger LOG = LoggerFactory.getLogger(CssUrlInspector.class);
    private static final Pattern PATTERN = Pattern.compile(WroUtil.loadRegexpWithKey("cssUrlRewrite"));

    public final String findAndReplace(String content, ItemHandler handler) {
        Matcher matcher = this.getMatcher(content);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String cssStatement = matcher.group();
            LOG.debug("Matched group: {}", (Object)cssStatement);
            if (new CssImportInspector(cssStatement).containsImport()) continue;
            LOG.debug("No @import detected");
            String originalDeclaration = this.getOriginalDeclaration(matcher);
            String originalUrl = this.getOriginalUrl(matcher);
            LOG.debug("originalDeclaration: {}", (Object)originalDeclaration);
            LOG.debug("originalUrl: {}", (Object)originalUrl);
            Validate.notNull((Object)originalUrl);
            matcher.appendReplacement(sb, handler.replace(originalDeclaration, originalUrl));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected Matcher getMatcher(String content) {
        return PATTERN.matcher(content);
    }

    protected String getOriginalDeclaration(Matcher matcher) {
        return matcher.group(0);
    }

    protected String getOriginalUrl(Matcher matcher) {
        String groupA = matcher.group(1);
        String originalUrl = groupA != null ? groupA : matcher.group(2);
        return originalUrl;
    }

    public static interface ItemHandler {
        public String replace(String var1, String var2);
    }
}

