/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.support.RedirectedStreamServletResponseWrapper;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.UrlUriLocator;
import ro.isdc.wro.util.WroUtil;

public class DispatcherStreamLocator {
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherStreamLocator.class);
    public static final String ATTRIBUTE_INCLUDED_BY_DISPATCHER = DispatcherStreamLocator.class.getName() + ".included_with_dispatcher";
    private int timeout = WroConfiguration.DEFAULT_CONNECTION_TIMEOUT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(HttpServletRequest request, HttpServletResponse response, String location) throws IOException {
        if (request == null || response == null || location == null) {
            throw new IOException("Cannot get stream for location: " + location + " because either request, response or location is not available");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        boolean warnOnEmptyStream = false;
        try {
            RequestDispatcher dispatcher = request.getRequestDispatcher(location);
            if (dispatcher != null) {
                ServletRequest servletRequest = this.getWrappedServletRequest(request, location);
                RedirectedStreamServletResponseWrapper servletResponse = new RedirectedStreamServletResponseWrapper(os, response);
                LOG.debug("dispatching request to location: {}", (Object)location);
                dispatcher.include(servletRequest, (ServletResponse)servletResponse);
                warnOnEmptyStream = true;
                servletResponse.getWriter().flush();
                os.close();
            }
        }
        catch (Exception e) {
            LOG.debug("Could not dispatch request for location {}", (Object)location);
            return this.locateExternal(request, location);
        }
        try {
            if (os.size() == 0) {
                InputStream inputStream = this.locateExternal(request, location);
                return inputStream;
            }
        }
        finally {
            if (warnOnEmptyStream && os.size() == 0) {
                LOG.debug("Wrong or empty resource with location: {}", (Object)location);
            }
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    public InputStream locateExternal(HttpServletRequest request, String location) throws IOException {
        String servletContextPath = request.getRequestURL().toString().replace(request.getServletPath(), "");
        String absolutePath = servletContextPath + location;
        LOG.debug("locateExternalUri: {}", (Object)absolutePath);
        return this.createExternalResourceLocator().locate(absolutePath);
    }

    UriLocator createExternalResourceLocator() {
        UrlUriLocator locator = new UrlUriLocator();
        locator.setEnableWildcards(false);
        locator.setTimeout(this.timeout);
        return locator;
    }

    private ServletRequest getWrappedServletRequest(HttpServletRequest request, final String location) {
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){

            public String getRequestURI() {
                return this.getContextPath() + location;
            }

            public String getPathInfo() {
                return WroUtil.getPathInfoFromLocation((HttpServletRequest)this, location);
            }

            public String getServletPath() {
                return WroUtil.getServletPathFromLocation((HttpServletRequest)this, location);
            }
        };
        wrappedRequest.setAttribute(ATTRIBUTE_INCLUDED_BY_DISPATCHER, (Object)Boolean.TRUE);
        return wrappedRequest;
    }

    public static boolean isIncludedRequest(HttpServletRequest request) {
        Validate.notNull((Object)request);
        return request.getAttribute(ATTRIBUTE_INCLUDED_BY_DISPATCHER) != null;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }
}

