/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.userdetails;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.security.ldap.userdetails.LdapUserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetailsImpl;
import org.springframework.util.Assert;

public class Person
extends LdapUserDetailsImpl {
    private static final long serialVersionUID = 520L;
    private String givenName;
    private String sn;
    private String description;
    private String telephoneNumber;
    private List<String> cn = new ArrayList<String>();

    protected Person() {
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getSn() {
        return this.sn;
    }

    public String[] getCn() {
        return this.cn.toArray(new String[0]);
    }

    public String getDescription() {
        return this.description;
    }

    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    protected void populateContext(DirContextAdapter adapter) {
        adapter.setAttributeValue("givenName", (Object)this.givenName);
        adapter.setAttributeValue("sn", (Object)this.sn);
        adapter.setAttributeValues("cn", (Object[])this.getCn());
        adapter.setAttributeValue("description", (Object)this.getDescription());
        adapter.setAttributeValue("telephoneNumber", (Object)this.getTelephoneNumber());
        if (this.getPassword() != null) {
            adapter.setAttributeValue("userPassword", (Object)this.getPassword());
        }
        adapter.setAttributeValues("objectclass", (Object[])new String[]{"top", "person"});
    }

    public static class Essence
    extends LdapUserDetailsImpl.Essence {
        public Essence() {
        }

        public Essence(DirContextOperations ctx) {
            super(ctx);
            this.setCn(ctx.getStringAttributes("cn"));
            this.setGivenName(ctx.getStringAttribute("givenName"));
            this.setSn(ctx.getStringAttribute("sn"));
            this.setDescription(ctx.getStringAttribute("description"));
            this.setTelephoneNumber(ctx.getStringAttribute("telephoneNumber"));
            Object passo = ctx.getObjectAttribute("userPassword");
            if (passo != null) {
                String password = LdapUtils.convertPasswordToString(passo);
                this.setPassword(password);
            }
        }

        public Essence(Person copyMe) {
            super(copyMe);
            this.setGivenName(copyMe.givenName);
            this.setSn(copyMe.sn);
            this.setDescription(copyMe.getDescription());
            this.setTelephoneNumber(copyMe.getTelephoneNumber());
            ((Person)this.instance).cn = new ArrayList(copyMe.cn);
        }

        @Override
        protected LdapUserDetailsImpl createTarget() {
            return new Person();
        }

        public void setGivenName(String givenName) {
            ((Person)this.instance).givenName = givenName;
        }

        public void setSn(String sn) {
            ((Person)this.instance).sn = sn;
        }

        public void setCn(String[] cn) {
            ((Person)this.instance).cn = Arrays.asList(cn);
        }

        public void addCn(String value) {
            ((Person)this.instance).cn.add(value);
        }

        public void setTelephoneNumber(String tel) {
            ((Person)this.instance).telephoneNumber = tel;
        }

        public void setDescription(String desc) {
            ((Person)this.instance).description = desc;
        }

        @Override
        public LdapUserDetails createUserDetails() {
            Person p = (Person)super.createUserDetails();
            Assert.notNull((Object)p.cn, (String)"person.sn cannot be null");
            Assert.notEmpty((Collection)p.cn, (String)"person.cn cannot be empty");
            return p;
        }
    }
}

