/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import java.util.List;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.NamespaceDeclarationsImpl;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pull.PullFromIterator;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.UnconstructedParent;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTreeWalker;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class TreeWalker
implements PullProvider,
SourceLocator {
    private NodeInfo startNode;
    private NodeInfo currentNode;
    private int currentEvent;
    private Stack iteratorStack = new Stack();
    private PipelineConfiguration pipe;
    private int[] nsBuffer = new int[10];

    public static PullProvider makeTreeWalker(NodeInfo startNode) {
        if (startNode instanceof UnconstructedParent) {
            return ((UnconstructedParent)startNode).getPuller();
        }
        if (startNode instanceof TinyNodeImpl) {
            switch (startNode.getNodeKind()) {
                case 1: 
                case 9: {
                    return new TinyTreeWalker((TinyNodeImpl)startNode);
                }
            }
            return new PullFromIterator(SingletonIterator.makeIterator(startNode));
        }
        return new TreeWalker(startNode);
    }

    private TreeWalker(NodeInfo startNode) {
        this.startNode = startNode;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public int next() throws XPathException {
        switch (this.currentEvent) {
            case 0: {
                this.currentNode = this.startNode;
                switch (this.currentNode.getNodeKind()) {
                    case 9: {
                        this.currentEvent = 2;
                        break;
                    }
                    case 1: {
                        this.currentEvent = 4;
                        break;
                    }
                    case 3: {
                        this.currentEvent = 8;
                        break;
                    }
                    case 8: {
                        this.currentEvent = 9;
                        break;
                    }
                    case 7: {
                        this.currentEvent = 10;
                        break;
                    }
                    case 2: {
                        this.currentEvent = 6;
                        break;
                    }
                    case 13: {
                        this.currentEvent = 7;
                    }
                }
                return this.currentEvent;
            }
            case 2: 
            case 4: {
                AxisIterator kids = this.currentNode.iterateAxis((byte)3);
                this.iteratorStack.push(kids);
                this.currentNode = (NodeInfo)kids.next();
                if (this.currentNode != null) {
                    switch (this.currentNode.getNodeKind()) {
                        case 1: {
                            this.currentEvent = 4;
                            break;
                        }
                        case 3: {
                            this.currentEvent = 8;
                            break;
                        }
                        case 8: {
                            this.currentEvent = 9;
                            break;
                        }
                        case 7: {
                            this.currentEvent = 10;
                        }
                    }
                    return this.currentEvent;
                }
                this.iteratorStack.pop();
                if (this.iteratorStack.isEmpty()) {
                    this.currentNode = this.startNode;
                }
                this.currentEvent = this.currentEvent == 2 ? 3 : 5;
                return this.currentEvent;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                if (this.iteratorStack.isEmpty()) {
                    if (this.currentNode == this.startNode) {
                        this.currentNode = null;
                        this.currentEvent = -1;
                    } else {
                        this.currentNode = this.startNode;
                        this.currentEvent = this.currentNode.getNodeKind() == 1 ? 5 : 3;
                    }
                    return this.currentEvent;
                }
                AxisIterator siblings = (AxisIterator)this.iteratorStack.peek();
                this.currentNode = (NodeInfo)siblings.next();
                if (this.currentNode == null) {
                    this.iteratorStack.pop();
                    if (this.iteratorStack.isEmpty()) {
                        this.currentNode = this.startNode;
                        this.currentEvent = this.currentNode.getNodeKind() == 1 ? 5 : 3;
                        return this.currentEvent;
                    }
                    AxisIterator uncles = (AxisIterator)this.iteratorStack.peek();
                    this.currentNode = (NodeInfo)uncles.current();
                    this.currentEvent = this.currentNode.getNodeKind() == 9 ? 3 : 5;
                    return this.currentEvent;
                }
                switch (this.currentNode.getNodeKind()) {
                    case 1: {
                        this.currentEvent = 4;
                        break;
                    }
                    case 3: {
                        this.currentEvent = 8;
                        break;
                    }
                    case 8: {
                        this.currentEvent = 9;
                        break;
                    }
                    case 7: {
                        this.currentEvent = 10;
                    }
                }
                return this.currentEvent;
            }
            case 3: 
            case 6: 
            case 7: {
                this.currentEvent = -1;
                return this.currentEvent;
            }
            case -1: {
                throw new IllegalStateException("Cannot call next() when input is exhausted");
            }
        }
        throw new IllegalStateException("Unrecognized event " + this.currentEvent);
    }

    public int current() {
        return this.currentEvent;
    }

    public AttributeCollection getAttributes() throws XPathException {
        if (this.currentNode.getNodeKind() == 1) {
            NodeInfo node;
            AttributeCollectionImpl atts = new AttributeCollectionImpl(this.startNode.getConfiguration());
            AxisIterator iter = this.currentNode.iterateAxis((byte)2);
            while ((node = (NodeInfo)iter.next()) != null) {
                atts.addAttribute(node.getNameCode(), node.getTypeAnnotation(), node.getStringValue(), 0L, 0);
            }
            return atts;
        }
        throw new IllegalStateException("getAttributes() called when current event is not ELEMENT_START");
    }

    public NamespaceDeclarations getNamespaceDeclarations() throws XPathException {
        if (this.currentNode.getNodeKind() == 1) {
            if (this.iteratorStack.isEmpty()) {
                int[] codes = NamespaceIterator.getInScopeNamespaceCodes(this.currentNode);
                return new NamespaceDeclarationsImpl(this.getNamePool(), codes);
            }
            return new NamespaceDeclarationsImpl(this.getNamePool(), this.currentNode.getDeclaredNamespaces(this.nsBuffer));
        }
        throw new IllegalStateException("getNamespaceDeclarations() called when current event is not ELEMENT_START");
    }

    public int skipToMatchingEnd() throws XPathException {
        switch (this.currentEvent) {
            case 2: {
                this.currentEvent = 3;
                return this.currentEvent;
            }
            case 4: {
                this.currentEvent = 5;
                return this.currentEvent;
            }
        }
        throw new IllegalStateException("Cannot call skipToMatchingEnd() except when at start of element or document");
    }

    public void close() {
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    public int getNameCode() {
        return this.currentNode.getNameCode();
    }

    public int getFingerprint() {
        return this.currentNode.getFingerprint();
    }

    public CharSequence getStringValue() throws XPathException {
        if (this.currentNode.getNodeKind() == 1) {
            this.skipToMatchingEnd();
        }
        return this.currentNode.getStringValueCS();
    }

    public int getTypeAnnotation() {
        return this.currentNode.getTypeAnnotation();
    }

    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    public SourceLocator getSourceLocator() {
        return this;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.currentNode.getSystemId();
    }

    public int getLineNumber() {
        return this.currentNode.getLineNumber();
    }

    public int getColumnNumber() {
        return -1;
    }

    public List getUnparsedEntities() {
        return null;
    }
}

