/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.concurrent;

import java.util.ArrayList;
import org.pvalsecc.concurrent.SynchronousTarget;

public class SynchronousTargetGroup
extends SynchronousTarget {
    protected ArrayList<SynchronousTarget> subs = new ArrayList(5);

    public SynchronousTargetGroup(String name, Runnable completedCallback) {
        super(completedCallback, name);
    }

    @Override
    protected boolean isVirgin() {
        for (int i = 0; i < this.subs.size(); ++i) {
            SynchronousTarget sub = this.subs.get(i);
            if (sub.isVirgin()) continue;
            return false;
        }
        return true;
    }

    public synchronized void add(SynchronousTarget sub) {
        if (!this.isVirgin()) {
            throw new RuntimeException("Cannot add a barrier");
        }
        this.subs.add(sub);
        new SubListener(sub);
    }

    private synchronized void subDone(SynchronousTarget sub) {
        if (!this.subs.remove(sub)) {
            throw new RuntimeException("Inconsitency");
        }
        if (this.subs.size() == 0) {
            this.call();
        }
    }

    @Override
    public synchronized void setTarget(int target) {
        for (int i = 0; i < this.subs.size(); ++i) {
            SynchronousTarget sub = this.subs.get(i);
            sub.setTarget(target);
        }
    }

    private class SubListener
    implements Runnable {
        private Runnable chained;
        private final SynchronousTarget sub;

        public SubListener(SynchronousTarget sub) {
            this.sub = sub;
            this.chained = sub.registerCompletedCallback(this);
        }

        @Override
        public void run() {
            if (this.chained != null) {
                this.chained.run();
            }
            SynchronousTargetGroup.this.subDone(this.sub);
        }
    }
}

