/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import com.lowagie.text.html.WebColors;
import java.awt.Color;
import org.ho.yaml.wrapper.AbstractWrapper;
import org.ho.yaml.wrapper.SimpleObjectWrapper;

public class ColorWrapper
extends AbstractWrapper
implements SimpleObjectWrapper {
    public ColorWrapper(Class<?> type) {
        super(type);
    }

    public void setObject(Object obj) {
        if (obj instanceof String) {
            super.setObject((Object)ColorWrapper.convertColor((String)obj));
        } else {
            super.setObject(obj);
        }
    }

    public Class<?> expectedArgType() {
        return String.class;
    }

    public Object getOutputValue() {
        return this.getObject().toString();
    }

    public static Color convertColor(String color) throws IllegalArgumentException {
        if (color == null) {
            return null;
        }
        if (color.startsWith("#") && color.length() == 4) {
            int r = Integer.parseInt(color.substring(1, 2) + color.substring(1, 2), 16);
            int g = Integer.parseInt(color.substring(2, 3) + color.substring(2, 3), 16);
            int b = Integer.parseInt(color.substring(3) + color.substring(3), 16);
            return new Color(r, g, b);
        }
        Color c = WebColors.getRGBColor((String)color);
        if (c != null && c.getAlpha() == 0) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue());
        }
        return c;
    }
}

