/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.util.Display;
import bak.pcj.util.Exceptions;
import java.io.Serializable;

public class IntRange
implements Comparable,
Serializable {
    private int first;
    private int last;

    public IntRange(int first, int last) {
        if (last < first) {
            Exceptions.invalidRangeBounds(String.valueOf(first), String.valueOf(last));
        }
        this.first = first;
        this.last = last;
    }

    public int first() {
        return this.first;
    }

    public int last() {
        return this.last;
    }

    public int length() {
        return this.last - this.first + 1;
    }

    public boolean intersects(IntRange range) {
        return this.first >= range.first && this.first <= range.last || range.first >= this.first && range.first <= this.last;
    }

    public boolean adjacentTo(IntRange range) {
        return this.last + 1 == range.first || range.last + 1 == this.first;
    }

    public boolean canMergeWith(IntRange range) {
        return this.intersects(range) || this.adjacentTo(range);
    }

    public IntRange mergeWith(IntRange range) {
        if (!this.canMergeWith(range)) {
            Exceptions.cannotMergeRanges(this, range);
        }
        return this.quickMergeWith(range);
    }

    private IntRange quickMergeWith(IntRange range) {
        int nfirst = this.first < range.first ? this.first : range.first;
        int nlast = this.last > range.last ? this.last : range.last;
        return new IntRange(nfirst, nlast);
    }

    public IntRange tryMergeWith(IntRange range) {
        if (!this.canMergeWith(range)) {
            return null;
        }
        return this.quickMergeWith(range);
    }

    public int intersectionLength(IntRange range) {
        int len;
        if (this.first >= range.first && this.first <= range.last) {
            int end = this.last <= range.last ? this.last : range.last;
            len = end - this.first + 1;
        } else if (range.first >= this.first && range.first <= this.last) {
            int end = this.last <= range.last ? this.last : range.last;
            len = end - range.first + 1;
        } else {
            len = 0;
        }
        return len;
    }

    public boolean contains(int v) {
        return v >= this.first && v <= this.last;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IntRange)) {
            return false;
        }
        IntRange range = (IntRange)obj;
        return this.first == range.first && this.last == range.last;
    }

    public int compareTo(Object obj) {
        IntRange range = (IntRange)obj;
        if (this.first < range.first) {
            return -1;
        }
        if (this.first > range.first) {
            return 1;
        }
        if (this.last < range.last) {
            return -1;
        }
        if (this.last > range.last) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.first ^ this.last;
    }

    public String toString() {
        return Display.display(this.first) + "-" + Display.display(this.last);
    }
}

