/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.DoubleCollection;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.hash.DefaultShortHashFunction;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ShortKeyDoubleMap;
import bak.pcj.map.ShortKeyDoubleMapIterator;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractShortKeyDoubleMap
implements ShortKeyDoubleMap {
    protected AbstractShortKeyDoubleMap() {
    }

    public void clear() {
        ShortKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public double remove(short key) {
        ShortKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            double value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultDouble();
    }

    public void putAll(ShortKeyDoubleMap map) {
        ShortKeyDoubleMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(short key) {
        ShortKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public double get(short key) {
        ShortKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultDouble();
    }

    public boolean containsValue(double value) {
        ShortKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShortKeyDoubleMap)) {
            return false;
        }
        ShortKeyDoubleMap map = (ShortKeyDoubleMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        ShortKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            short k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        ShortKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultShortHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultDoubleHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        ShortKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public double tget(short key) {
        double value = this.get(key);
        if (value == MapDefaults.defaultDouble() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        ShortKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract DoubleCollection values();

    public abstract double put(short var1, double var2);

    public abstract double lget();

    public abstract ShortSet keySet();

    public abstract ShortKeyDoubleMapIterator entries();
}

