/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.CharCollection;
import bak.pcj.hash.DefaultCharHashFunction;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.map.DoubleKeyCharMap;
import bak.pcj.map.DoubleKeyCharMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractDoubleKeyCharMap
implements DoubleKeyCharMap {
    protected AbstractDoubleKeyCharMap() {
    }

    public void clear() {
        DoubleKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public char remove(double key) {
        DoubleKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            char value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultChar();
    }

    public void putAll(DoubleKeyCharMap map) {
        DoubleKeyCharMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(double key) {
        DoubleKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public char get(double key) {
        DoubleKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultChar();
    }

    public boolean containsValue(char value) {
        DoubleKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleKeyCharMap)) {
            return false;
        }
        DoubleKeyCharMap map = (DoubleKeyCharMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        DoubleKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            double k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        DoubleKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultDoubleHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultCharHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        DoubleKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public char tget(double key) {
        char value = this.get(key);
        if (value == MapDefaults.defaultChar() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        DoubleKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract CharCollection values();

    public abstract char put(double var1, char var3);

    public abstract char lget();

    public abstract DoubleSet keySet();

    public abstract DoubleKeyCharMapIterator entries();
}

