/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.adapter.ListIteratorToDoubleListIteratorAdapter;
import bak.pcj.list.AbstractDoubleList;
import bak.pcj.list.DoubleListIterator;
import bak.pcj.util.Exceptions;
import java.util.List;

public class ListToDoubleListAdapter
extends AbstractDoubleList {
    protected List list;

    public ListToDoubleListAdapter(List list) {
        this(list, false);
    }

    public ListToDoubleListAdapter(List list, boolean validate) {
        if (list == null) {
            Exceptions.nullArgument("list");
        }
        this.list = list;
        if (validate) {
            this.evalidate();
        }
    }

    public void add(int index, double v) {
        this.list.add(index, new Double(v));
    }

    public double get(int index) {
        return (Double)this.list.get(index);
    }

    public DoubleListIterator listIterator(int index) {
        return new ListIteratorToDoubleListIteratorAdapter(this.list.listIterator(index));
    }

    public double removeElementAt(int index) {
        return (Double)this.list.remove(index);
    }

    public double set(int index, double v) {
        return this.list.set(index, new Double(v));
    }

    public int size() {
        return this.list.size();
    }

    public boolean validate() {
        return Adapter.isDoubleAdaptable(this.list);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("list");
        }
    }
}

