/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNegotiateAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultHTTPNegotiateAuthentication
extends HTTPNegotiateAuthentication {
    private static final String NEGOTIATE_TYPE_PROPERTY = "svnkit.negotiate.type";
    private static final String NEGOTIATE_TYPE_SPNEGO = "spnego";
    private static final String NEGOTIATE_TYPE_KERBEROS = "krb";
    private static Map ourOids = new SVNHashMap();
    private static volatile Boolean ourIsNegotiateSupported;
    private GSSManager myGSSManager = GSSManager.getInstance();
    private GSSContext myGSSContext;
    private Oid mySpnegoOid;
    private Subject mySubject;
    private byte[] myToken;
    private int myTokenLength;

    private static Oid getDefaultOID() {
        Oid oid;
        String defaultOid = System.getProperty(NEGOTIATE_TYPE_PROPERTY, NEGOTIATE_TYPE_KERBEROS);
        if (defaultOid == null || "".equals(defaultOid)) {
            defaultOid = NEGOTIATE_TYPE_KERBEROS;
        }
        if ((oid = (Oid)ourOids.get(defaultOid)) != null) {
            return oid;
        }
        return (Oid)ourOids.get(NEGOTIATE_TYPE_KERBEROS);
    }

    public DefaultHTTPNegotiateAuthentication(DefaultHTTPNegotiateAuthentication prevAuth) {
        if (prevAuth != null) {
            this.mySubject = prevAuth.mySubject;
        }
    }

    public DefaultHTTPNegotiateAuthentication() {
        this((DefaultHTTPNegotiateAuthentication)null);
    }

    public static synchronized boolean isSupported() {
        if (ourIsNegotiateSupported == null) {
            Oid spnegoOid = DefaultHTTPNegotiateAuthentication.getDefaultOID();
            Oid[] supportedOids = GSSManager.getInstance().getMechs();
            for (int i = 0; i < supportedOids.length; ++i) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: supported OID: " + supportedOids[i]);
            }
            ourIsNegotiateSupported = Arrays.asList(GSSManager.getInstance().getMechs()).contains(spnegoOid);
        }
        return ourIsNegotiateSupported;
    }

    public void respondTo(String challenge) {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: respond to, challenge: " + challenge);
        if (challenge == null) {
            this.myToken = new byte[0];
            this.myTokenLength = 0;
        } else {
            this.myToken = new byte[(challenge.length() * 3 + 3) / 4];
            this.myTokenLength = SVNBase64.base64ToByteArray(new StringBuffer(challenge), this.myToken);
        }
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: respond to, token length: " + this.myTokenLength);
    }

    private void initializeSubject() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize subject");
        if (this.mySubject != null) {
            return;
        }
        try {
            LoginContext ctx = new LoginContext("com.sun.security.jgss.krb5.initiate", new SVNKitCallbackHandler());
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize subject, login context: " + ctx);
            ctx.login();
            this.mySubject = ctx.getSubject();
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize subject, subject: " + this.mySubject);
        }
        catch (LoginException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
        }
    }

    private void initializeContext() throws GSSException {
        if (this.mySpnegoOid == null) {
            this.mySpnegoOid = DefaultHTTPNegotiateAuthentication.getDefaultOID();
        }
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize context, OID: " + this.mySpnegoOid);
        GSSCredential credentials = this.myGSSManager.createCredential(1);
        GSSName serverName = this.myGSSManager.createName(this.getServerPrincipalName(), GSSName.NT_HOSTBASED_SERVICE);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize context, server name: " + serverName);
        this.myGSSContext = this.myGSSManager.createContext(serverName, this.mySpnegoOid, credentials, 0);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize context, GSS Context: " + this.myGSSContext);
    }

    public String authenticate() throws SVNException {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate: isStarted:" + this.isStarted());
        if (!this.isStarted()) {
            this.initializeSubject();
        }
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws SVNException {
                byte[] outtoken;
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate action: isStarted: " + DefaultHTTPNegotiateAuthentication.this.isStarted());
                if (!DefaultHTTPNegotiateAuthentication.this.isStarted()) {
                    try {
                        DefaultHTTPNegotiateAuthentication.this.initializeContext();
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate action: context initializaed");
                    }
                    catch (GSSException gsse) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Negotiate authentication failed: ''{0}''", (Object)gsse.getMajorString());
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                        return null;
                    }
                }
                try {
                    DefaultHTTPNegotiateAuthentication.this.myGSSContext.requestCredDeleg(true);
                    outtoken = DefaultHTTPNegotiateAuthentication.this.myGSSContext.initSecContext(DefaultHTTPNegotiateAuthentication.this.myToken, 0, DefaultHTTPNegotiateAuthentication.this.myTokenLength);
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate action: out token: " + outtoken);
                    if (outtoken != null) {
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate action: out token: " + SVNBase64.byteArrayToBase64(outtoken));
                    }
                }
                catch (GSSException gsse) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Negotiate authentication failed: ''{0}''", (Object)gsse.getMajorString());
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                    return null;
                }
                if (DefaultHTTPNegotiateAuthentication.this.myToken != null) {
                    return "Negotiate " + SVNBase64.byteArrayToBase64(outtoken);
                }
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate action: myToken is null");
                return null;
            }
        };
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate: subject:" + this.mySubject);
        if (this.mySubject != null) {
            try {
                String result = (String)Subject.doAs(this.mySubject, action);
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate: result:" + result);
                return result;
            }
            catch (PrivilegedActionException e) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
                Throwable cause = e.getCause();
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, cause);
                if (cause instanceof SVNException) {
                    throw (SVNException)cause;
                }
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, e), SVNLogType.NETWORK);
            }
        }
        try {
            String result = (String)action.run();
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate: result (2):" + result);
            return (String)action.run();
        }
        catch (Exception cause) {
            if (cause instanceof SVNException) {
                throw (SVNException)cause;
            }
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, cause), SVNLogType.NETWORK);
            return null;
        }
    }

    public boolean isStarted() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: isStarted: " + this.myGSSContext);
        return this.myGSSContext != null;
    }

    public boolean needsLogin() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: needsLogin");
        this.initializeSubject();
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: needsLogin, mySubject: " + this.mySubject);
        return this.mySubject == null;
    }

    static {
        try {
            ourOids.put(NEGOTIATE_TYPE_KERBEROS, new Oid("1.2.840.113554.1.2.2"));
        }
        catch (GSSException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
        }
        try {
            ourOids.put(NEGOTIATE_TYPE_SPNEGO, new Oid("1.3.6.1.5.5.2"));
        }
        catch (GSSException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
        }
    }

    private class SVNKitCallbackHandler
    implements CallbackHandler {
        private SVNKitCallbackHandler() {
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName(DefaultHTTPNegotiateAuthentication.this.getUserName());
                    continue;
                }
                if (!(callbacks[i] instanceof PasswordCallback)) continue;
                ((PasswordCallback)callbacks[i]).setPassword(DefaultHTTPNegotiateAuthentication.this.getPassword() == null ? null : DefaultHTTPNegotiateAuthentication.this.getPassword().toCharArray());
            }
        }
    }
}

