/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.stream.MatchpointSearchResults;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;

public class RollbackException
extends RestartRequiredException {
    private final VLSN lastTxnEnd;
    private final VLSN matchpointVLSN;
    private final String nodeName;
    private final MatchpointSearchResults searchResults;

    public RollbackException(RepImpl repImpl, VLSN lastTxnEnd, VLSN matchpointVLSN, MatchpointSearchResults searchResults) {
        super(repImpl, EnvironmentFailureReason.HARD_RECOVERY);
        this.lastTxnEnd = lastTxnEnd;
        this.matchpointVLSN = matchpointVLSN;
        this.searchResults = searchResults;
        this.nodeName = repImpl.getName();
    }

    public String getMessage() {
        long matchpointLSN = this.searchResults.getMatchpointLSN();
        return "Node " + this.nodeName + " must rollback" + this.searchResults.getRollbackMsg() + " in order to rejoin the replication group. All existing " + "ReplicatedEnvironment handles must be closed and " + "reinstantiated.  Log files were truncated to file 0x" + DbLsn.getFileNumber(matchpointLSN) + ", offset 0x" + DbLsn.getFileOffset(matchpointLSN) + ", vlsn " + this.matchpointVLSN;
    }

    public Long getEarliestTransactionCommitTime() {
        if (this.searchResults.getEarliestPassedTxn() == null) {
            return null;
        }
        return this.searchResults.getEarliestPassedTxn().time.getTime();
    }

    public long getEarliestTransactionId() {
        if (this.searchResults.getEarliestPassedTxn() == null) {
            return 0L;
        }
        return this.searchResults.getEarliestPassedTxn().id;
    }

    public RollbackException(String message, RollbackException cause) {
        super(message, cause);
        this.lastTxnEnd = cause.lastTxnEnd;
        this.matchpointVLSN = cause.matchpointVLSN;
        this.searchResults = cause.searchResults;
        this.nodeName = cause.nodeName;
    }

    public RollbackException wrapSelf(String msg) {
        return new RollbackException(msg, this);
    }
}

