/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.responses;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fao.oaipmh.OaiPmh;
import org.fao.oaipmh.util.Lib;
import org.jdom.Content;
import org.jdom.Element;

public class SetInfo {
    private String spec;
    private String name;
    private List<Element> descriptions = new ArrayList<Element>();

    public SetInfo() {
    }

    public SetInfo(String spec, String name) {
        this.spec = spec;
        this.name = name;
    }

    public SetInfo(Element set) {
        this.build(set);
    }

    public String getSpec() {
        return this.spec;
    }

    public String getName() {
        return this.name;
    }

    public Iterator<Element> getDescriptions() {
        return this.descriptions.iterator();
    }

    public Element toXml() {
        Element set = new Element("set", OaiPmh.Namespaces.OAI_PMH);
        Lib.add(set, "setSpec", this.spec);
        Lib.add(set, "setName", this.name);
        for (Element descr : this.descriptions) {
            set.addContent((Content)((Element)descr.clone()));
        }
        return set;
    }

    private void build(Element set) {
        this.spec = set.getChildText("setSpec", OaiPmh.Namespaces.OAI_PMH);
        this.name = set.getChildText("setName", OaiPmh.Namespaces.OAI_PMH);
        for (Object o : set.getChildren("setDescription", OaiPmh.Namespaces.OAI_PMH)) {
            this.descriptions.add((Element)o);
        }
    }
}

