/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.responses;

import java.util.HashMap;
import java.util.Map;
import org.fao.geonet.domain.ISODate;
import org.fao.oaipmh.OaiPmh;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public abstract class AbstractResponse {
    private Element response;
    private ISODate responseDate;
    private Map<String, String> request = new HashMap<String, String>();

    public AbstractResponse() {
        this.responseDate = new ISODate();
    }

    public AbstractResponse(Element response) {
        this.response = response;
        this.build(response);
    }

    public Element getResponse() {
        return this.response;
    }

    public ISODate getResponseDate() {
        return this.responseDate;
    }

    public void setResponseDate(ISODate date) {
        this.responseDate = date;
    }

    public abstract Element toXml();

    protected void add(Element parent, String name, String value) {
        parent.addContent((Content)new Element(name, OaiPmh.Namespaces.OAI_PMH).setText(value));
    }

    private void build(Element response) {
        this.responseDate = new ISODate(response.getChildText("responseDate", OaiPmh.Namespaces.OAI_PMH));
        Element req = response.getChild("request", OaiPmh.Namespaces.OAI_PMH);
        for (Object o : req.getAttributes()) {
            Attribute attr = (Attribute)o;
            this.request.put(attr.getName(), attr.getValue());
        }
    }
}

